/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.FileUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class FilePreviewer
extends JComponent
implements PropertyChangeListener {
    Color back;
    ImageIcon thumbnail = null;
    Image img;
    Dimension sz;
    File f = null;

    public FilePreviewer(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.f != null) {
            this.img = FileUtils.getImage(this.f, true, this.back);
            if (this.img == null) {
                return;
            }
            if (this.img.getWidth(null) > 90) {
                this.img = this.img.getScaledInstance(90, -1, 1);
            }
            this.thumbnail = new ImageIcon(this.img);
        }
    }

    public void paint(Graphics graphics) {
        if (this.img == null) {
            if (this.back == null) {
                this.back = this.getParent().getBackground();
                this.sz = this.getSize();
            }
            graphics.setColor(this.back);
            graphics.fillRect(0, 0, this.sz.width, this.sz.height);
        } else {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
            graphics.drawString("Wid:" + this.img.getWidth(null) + " Hgt:" + this.img.getHeight(null), 2, 10);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "SelectedFileChangedProperty") {
            this.f = (File)propertyChangeEvent.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }
}

