/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.ACreator;
import com.equitysoft.icon.B2Creator;
import com.equitysoft.icon.BCreator;
import com.equitysoft.icon.Bar;
import com.equitysoft.icon.CutImage;
import com.equitysoft.icon.DisplayMenu;
import com.equitysoft.icon.FileFinder;
import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.GCreator;
import com.equitysoft.icon.GCreator128;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPMsg;
import com.equitysoft.icon.IPQ;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.ISave;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.ImageOpener;
import com.equitysoft.icon.JAIMethods;
import com.equitysoft.icon.JPEGQuality;
import com.equitysoft.icon.OpenFileDialog;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.XBMCreator;
import com.equitysoft.icon.XPMCreator;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

class FileManager {
    static final int JPEG = 0;
    static final int GIF87 = 1;
    static final int GIF89 = 2;
    static final int AGIF = 3;
    static final int PNG = 4;
    static final int TRANS_PNG = 5;
    static final int BMP = 6;
    static final int BMP8 = 7;
    static final int BMP24 = 8;
    static final int ICO = 9;
    static final int CUR = 10;
    static final int ANI = 11;
    static final int PICT = 12;
    static final int XBM = 13;
    static final int XPM = 14;
    static final int XPM_HOT = 15;
    static final int SHAPE = 16;
    static final int TIFF = 17;
    static boolean haveqt;
    static boolean havejai;
    static boolean a675;
    static File chooserdir;
    static File currfile;
    static int filetype;

    FileManager() {
    }

    private static void a() {
        new IPMsg("Lines appear across saved images until the software is registered (use UNDO to remove)");
    }

    static File checkExtension(File file, int n) {
        int n2;
        String string = FileManager.getTypeAsString(n);
        String string2 = file.getName();
        int n3 = string2.indexOf(46);
        if (n3 == (n2 = string2.length() - 1)) {
            return new File(file.getParent(), String.valueOf(string2) + string);
        }
        if (n3 > -1) {
            return file;
        }
        return new File(file.getParent(), String.valueOf(string2) + '.' + string);
    }

    static void cutFile(boolean bl) {
        File file = FileManager.getChooserFile("Choose the image from which to cut from.");
        if (file == null) {
            return;
        }
        Image image = FileUtils.getImage(file, true, IconPainter.backcol);
        if (image != null) {
            new CutImage(image, bl);
        }
    }

    static File getChooserFile(String string) {
        File file;
        String[] stringArray = new String[]{".jpg", ".gif", ".ani", ".ico", ".cur", ".bmp", ".xbm", ".xpm", ".bm", ".pm", "", "", "", ""};
        int n = 10;
        if (havejai) {
            stringArray[n] = ".png";
            stringArray[++n] = ".tif";
            stringArray[++n] = ".tiff";
            ++n;
        }
        if (haveqt) {
            stringArray[n] = ".pct";
            ++n;
        }
        if ((file = ImageOpener.ask(chooserdir, string, "Selected file", stringArray, n)) == null) {
            return null;
        }
        chooserdir = file.getParentFile();
        if (!file.exists()) {
            new IPZap("Unable to find the file " + file.getName());
            return null;
        }
        return file;
    }

    static File getSaveFile() {
        String[] stringArray = new String[]{"." + FileManager.getTypeAsString(filetype)};
        File file = FileFinder.ask(chooserdir, "Specify the saved file name", 2, "Name of " + stringArray[0] + " file", stringArray, 1);
        if (file != null) {
            chooserdir = file.getParentFile();
        }
        return file;
    }

    static String getTypeAsString(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return "gif";
            }
            case 0: {
                return "jpg";
            }
            case 7: {
                return "bmp";
            }
            case 8: {
                return "bmp";
            }
            case 4: 
            case 5: {
                return "png";
            }
            case 9: {
                return "ico";
            }
            case 10: {
                return "cur";
            }
            case 11: {
                return "ani";
            }
            case 12: {
                return "pct";
            }
            case 13: {
                return "xbm";
            }
            case 14: {
                return "xpm";
            }
            case 15: {
                return "xpm";
            }
            case 16: {
                return "ips";
            }
            case 17: {
                return "tif";
            }
        }
        return null;
    }

    static void openFile() {
        File file = FileManager.getChooserFile("Choose the image file to open");
        if (file != null) {
            FileManager.tryOpen(file);
        }
    }

    static void overlayFile() {
        File file = FileManager.getChooserFile("Choose the image to overlay.");
        if (file == null) {
            return;
        }
        Image image = IPUtils.getImage(file);
        if (image == null) {
            return;
        }
        IconPainter.startAdd();
        Graphics2D graphics2D = IconPainter.transimg.createGraphics();
        graphics2D.drawImage(image, (IconPainter.cols - image.getWidth(null)) / 2, (IconPainter.rows - image.getHeight(null)) / 2, null);
        IPLib.paintTransImg();
    }

    static void saveFile(boolean bl) {
        Object object;
        Object object2;
        Status.clear();
        File file = null;
        if (bl || currfile == null) {
            file = FileManager.getSaveFile();
            if (file == null) {
                return;
            }
            if ((file = FileManager.checkExtension(file, filetype)).exists() && filetype != 10 && filetype != 9 && !IPQ.ask("Overwrite the existing file with this name?", "Overwrite", "Cancel")) {
                return;
            }
        } else {
            file = currfile;
        }
        if (!a675) {
            IconPainter.startAdd();
            object2 = IconPainter.curr;
            object = ((BufferedImage)object2).createGraphics();
            int n = ((BufferedImage)object2).getWidth() / 2;
            int n2 = ((BufferedImage)object2).getHeight() / 2;
            ((Graphics)object).setColor(Color.darkGray);
            ((Graphics)object).drawLine(n, 0, n, ((BufferedImage)object2).getHeight());
            ((Graphics)object).drawLine(0, n2, ((BufferedImage)object2).getWidth(), n2);
            IconPainter.refreshAll();
            FileManager.a();
        }
        switch (filetype) {
            case 0: {
                if (FileManager.saveJPEG(file, IconPainter.curr)) break;
                return;
            }
            case 1: {
                if (!(DisplayMenu.gif.isYes() ? !GCreator.go(file, IconPainter.curr, false) : !GCreator128.go(file, IconPainter.curr, false))) break;
                return;
            }
            case 2: {
                if (!(DisplayMenu.gif.isYes() ? !GCreator.go(file, IconPainter.curr, true) : !GCreator128.go(file, IconPainter.curr, true))) break;
                return;
            }
            case 7: {
                object2 = new B2Creator();
                if (((B2Creator)object2).saveIt(file, IconPainter.curr)) break;
                return;
            }
            case 8: {
                object = new BCreator();
                if (((BCreator)object).saveIt(file, IconPainter.curr)) break;
                return;
            }
            case 10: {
                if (ISave.go(file, 10)) break;
                return;
            }
            case 9: {
                if (ISave.go(file, 9)) break;
                return;
            }
            case 11: {
                if (ACreator.saveA(file)) break;
                return;
            }
            case 4: 
            case 5: {
                if (JAIMethods.savePNG(file, IconPainter.curr, filetype)) break;
                return;
            }
            case 17: {
                if (JAIMethods.saveTiff(file, IconPainter.curr)) break;
                return;
            }
            case 13: {
                if (XBMCreator.saveIt(file)) break;
                return;
            }
            case 14: {
                if (XPMCreator.saveIt(file, 14)) break;
                return;
            }
            case 15: {
                if (XPMCreator.saveIt(file, 15)) break;
                return;
            }
        }
        if (bl || currfile == null) {
            Bar.setFile(file);
        }
    }

    static boolean saveJPEG(File file, BufferedImage bufferedImage) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(JPEGQuality.getQuality(), false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            new IPZap("Unable to write the JPEG file to disk.");
            return false;
        }
        return true;
    }

    static void tryOpen(File file) {
        Image image = FileUtils.getImage(file, false, IconPainter.backcol);
        if (image == null) {
            return;
        }
        IPUtils.completeClear();
        if (image.getWidth(null) != IconPainter.cols || image.getHeight(null) != IconPainter.rows) {
            new OpenFileDialog(image, file);
        } else {
            Bar.setFile(file);
            Graphics2D graphics2D = IconPainter.curr.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            image.flush();
            IconPainter.startAdd();
            IconPainter.refreshAll();
        }
        System.gc();
    }
}

