/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.ImageEffect;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.util.Random;

class EffectUtils {
    EffectUtils() {
    }

    static void blur(String string) {
        Kernel kernel;
        if (string.startsWith("Low")) {
            float f = 0.33333334f;
            float[] fArray = new float[3];
            int n = 0;
            while (n < 3) {
                fArray[n] = f;
                ++n;
            }
            kernel = new Kernel(3, 1, fArray);
        } else if (string.startsWith("Medium")) {
            float f = 0.11111111f;
            float[] fArray = new float[9];
            int n = 0;
            while (n < 9) {
                fArray[n] = f;
                ++n;
            }
            kernel = new Kernel(3, 3, fArray);
        } else {
            float f = 0.04f;
            float[] fArray = new float[25];
            int n = 0;
            while (n < 25) {
                fArray[n] = f;
                ++n;
            }
            kernel = new Kernel(5, 5, fArray);
        }
        ImageEffect.applyConvolve(kernel, false);
    }

    static void brighten(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, String string) {
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n2 = nArray.length;
        int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        float f = (float)n / 100.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        int n3 = 0;
        if (string.endsWith("red")) {
            n3 = 1;
        } else if (string.endsWith("green")) {
            n3 = 2;
        } else if (string.endsWith("blue")) {
            n3 = 3;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n4];
            int n6 = (n5 & 0xFF0000) >> 16;
            int n7 = (n5 & 0xFF00) >> 8;
            int n8 = n5 & 0xFF;
            switch (n3) {
                case 1: {
                    n6 = (int)((float)n6 + (float)(255 - n6) * f);
                    break;
                }
                case 2: {
                    n7 = (int)((float)n7 + (float)(255 - n7) * f);
                    break;
                }
                case 3: {
                    n8 = (int)((float)n8 + (float)(255 - n8) * f);
                    break;
                }
                default: {
                    n6 = (int)((float)n6 + (float)(255 - n6) * f);
                    n7 = (int)((float)n7 + (float)(255 - n7) * f);
                    n8 = (int)((float)n8 + (float)(255 - n8) * f);
                }
            }
            nArray2[n4] = (n5 & 0xFF000000) + (n6 << 16) + (n7 << 8) + n8;
            ++n4;
        }
    }

    static void buttonize(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, String string) {
        int n2 = bufferedImage2.getWidth();
        int n3 = bufferedImage2.getHeight();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setColor(string.endsWith("up") ? new Color(225, 225, 225, 125) : new Color(55, 55, 55, 125));
        nArray[0] = 0;
        nArray2[0] = 0;
        nArray[1] = n;
        nArray2[1] = n;
        nArray[2] = n;
        nArray2[2] = n3 - n;
        nArray[3] = 0;
        nArray2[3] = n3;
        graphics2D.fillPolygon(nArray, nArray2, 4);
        graphics2D.setColor(string.endsWith("up") ? new Color(190, 190, 190, 190) : new Color(85, 85, 85, 125));
        nArray[0] = 0;
        nArray2[0] = 0;
        nArray[1] = n;
        nArray2[1] = n;
        nArray[2] = n2 - n;
        nArray2[2] = n;
        nArray[3] = n2;
        nArray2[3] = 0;
        graphics2D.fillPolygon(nArray, nArray2, 4);
        graphics2D.setColor(string.endsWith("up") ? new Color(85, 85, 85, 125) : new Color(190, 190, 190, 125));
        nArray[0] = n2;
        nArray2[0] = 0;
        nArray[1] = n2 - n;
        nArray2[1] = n;
        nArray[2] = n2 - n;
        nArray2[2] = n3 - n;
        nArray[3] = n2;
        nArray2[3] = n3;
        graphics2D.fillPolygon(nArray, nArray2, 4);
        graphics2D.setColor(string.endsWith("up") ? new Color(55, 55, 55, 125) : new Color(225, 225, 225, 125));
        nArray[0] = 0;
        nArray2[0] = n3;
        nArray[1] = n;
        nArray2[1] = n3 - n;
        nArray[2] = n2 - n;
        nArray2[2] = n3 - n;
        nArray[3] = n2;
        nArray2[3] = n3;
        graphics2D.fillPolygon(nArray, nArray2, 4);
    }

    static void check(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, String string) {
        Random random = new Random();
        Color color = new Color(225, 225, 225, 125);
        Color color2 = new Color(190, 190, 190, 125);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        int n2 = bufferedImage2.getWidth();
        int n3 = bufferedImage2.getHeight();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                if (bl) {
                    graphics2D.setColor(color);
                    bl = false;
                } else {
                    graphics2D.setColor(color2);
                    bl = true;
                }
                if (string.startsWith("Random")) {
                    graphics2D.setColor(new Color(100, 100, 100, random.nextInt(50) + 100));
                }
                graphics2D.fillRect(n5, n4, n, n);
                n5 += n;
            }
            if (bl2) {
                bl2 = false;
                bl = false;
            } else {
                bl2 = true;
                bl = true;
            }
            n4 += n;
        }
    }

    static void darken(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, String string) {
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n2 = nArray.length;
        int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        float f = n;
        float f2 = 1.0f - f / 100.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        int n3 = 0;
        if (string.endsWith("red")) {
            n3 = 1;
        } else if (string.endsWith("green")) {
            n3 = 2;
        } else if (string.endsWith("blue")) {
            n3 = 3;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n4];
            int n6 = (n5 & 0xFF0000) >> 16;
            int n7 = (n5 & 0xFF00) >> 8;
            int n8 = n5 & 0xFF;
            switch (n3) {
                case 1: {
                    n6 = (int)((float)n6 * f2);
                    break;
                }
                case 2: {
                    n7 = (int)((float)n7 * f2);
                    break;
                }
                case 3: {
                    n8 = (int)((float)n8 * f2);
                    break;
                }
                default: {
                    n6 = (int)((float)n6 * f2);
                    n7 = (int)((float)n7 * f2);
                    n8 = (int)((float)n8 * f2);
                }
            }
            nArray2[n4] = (n5 & 0xFF000000) + (n6 << 16) + (n7 << 8) + n8;
            ++n4;
        }
    }

    static void edge(String string) {
        Kernel kernel = null;
        float f = -1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        if (string.startsWith("High")) {
            float[] fArray = new float[]{f, f, f, f, f2, f, f, f, f2, f3, f, f, f2, f3, f3, f, f2, f3, f3, f3, f2, f3, f3, f3, f3};
            kernel = new Kernel(5, 5, fArray);
        } else if (string.startsWith("Medium")) {
            float[] fArray = new float[]{f, f, f2, f, f2, f3, f2, f3, f3};
            kernel = new Kernel(3, 3, fArray);
        } else {
            float[] fArray = new float[]{f2, f3, f2, f3, -4.0f, f3, f2, f3, f2};
            kernel = new Kernel(3, 3, fArray);
        }
        ImageEffect.applyConvolve(kernel, true);
    }

    static void fuzz(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        Random random = new Random();
        int n2 = bufferedImage2.getWidth();
        int n3 = bufferedImage2.getHeight();
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = random.nextInt(n + 1);
                n8 = random.nextBoolean() ? n7 - n8 : n7 + n8;
                if (n8 < 0) {
                    n8 = 0;
                } else if (n8 > n4) {
                    n8 = n4;
                }
                int n9 = random.nextInt(n);
                n9 = random.nextBoolean() ? n6 - n9 : n6 + n9;
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > n5) {
                    n9 = n5;
                }
                bufferedImage2.setRGB(n7, n6, bufferedImage.getRGB(n8, n9));
                ++n7;
            }
            ++n6;
        }
    }

    static void grayout(BufferedImage bufferedImage) {
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            int n7 = (n4 * 3 + n5 * 4 + n6 * 2) / 9;
            nArray[n2] = (n3 & 0xFF000000) + (n7 << 16) + (n7 << 8) + n7;
            ++n2;
        }
    }

    static void invert(String string, BufferedImage bufferedImage) {
        int n = 0;
        if (string.endsWith("Red")) {
            n = 1;
        } else if (string.endsWith("Green")) {
            n = 2;
        } else if (string.endsWith("Blue")) {
            n = 3;
        }
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block11: {
                int n4 = nArray[n3];
                int n5 = (n4 & 0xFF0000) >> 16;
                int n6 = (n4 & 0xFF00) >> 8;
                int n7 = n4 & 0xFF;
                switch (n) {
                    case 1: {
                        n5 = 255 - n5;
                        break;
                    }
                    case 2: {
                        n6 = 255 - n5;
                        break;
                    }
                    case 3: {
                        n7 = 255 - n7;
                        break;
                    }
                    default: {
                        nArray[n3] = n4 ^ 0xFFFFFF;
                        break block11;
                    }
                }
                nArray[n3] = (n4 & 0xFF000000) + (n5 << 16) + (n6 << 8) + n7;
            }
            ++n3;
        }
    }

    static void refreshBack(BufferedImage bufferedImage) {
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = nArray.length;
        int[] nArray2 = ((DataBufferInt)IconPainter.curr.getRaster().getDataBuffer()).getData();
        int n2 = IconPainter.back;
        int n3 = 0;
        while (n3 < n) {
            if (nArray2[n3] == n2) {
                nArray[n3] = n2;
            }
            ++n3;
        }
    }

    static void sharpen(String string) {
        Kernel kernel = null;
        float f = -1.0f;
        if (string.startsWith("Low")) {
            float[] fArray = new float[9];
            fArray[1] = f;
            fArray[3] = f;
            fArray[4] = 5.0f;
            fArray[5] = f;
            fArray[7] = f;
            float[] fArray2 = fArray;
            kernel = new Kernel(3, 3, fArray2);
        } else if (string.startsWith("Medium")) {
            float[] fArray = new float[9];
            int n = 0;
            while (n < 9) {
                fArray[n] = f;
                ++n;
            }
            fArray[4] = 9.0f;
            kernel = new Kernel(3, 3, fArray);
        } else {
            float[] fArray = new float[25];
            int n = 0;
            while (n < 25) {
                fArray[n] = f;
                ++n;
            }
            fArray[12] = 24.0f;
            kernel = new Kernel(5, 5, fArray);
        }
        ImageEffect.applyConvolve(kernel, false);
    }
}

