/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.Status;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class EditMenu
extends JMenu
implements ActionListener {
    String CLIP = "Set clip area";
    String NOCLIP = "Remove clip area";
    String CUT = "Cut";
    String COPY = "Copy";
    String PASTE = "Paste";
    String CLONE = "Create overlay clone";
    String NORTH = "Mirror top in bottom";
    String WEST = "Mirror left in right";
    String TILE = "Create tile from top left";
    String FLIP_H = "Horizontal flip";
    String FLIP_V = "Vertical flip";
    String CROP = "Crop";
    String REPEAT = "Repeat image section";
    static JMenuItem clip;
    static JMenuItem noclip;
    static JMenuItem paste;

    EditMenu() {
        super("  Edit  ");
        this.setMnemonic(69);
        this.add(IPUtils.getMI(this.CUT, this, 67));
        this.add(IPUtils.getMI(this.COPY, this, 89));
        paste = IPUtils.getMI(this.PASTE, this, 80);
        this.add(paste);
        paste.setEnabled(false);
        this.add(IPUtils.getMI(this.CROP, this, 80));
        this.addSeparator();
        clip = IPUtils.getMI(this.CLIP, this, 65);
        this.add(clip);
        noclip = IPUtils.getMI(this.NOCLIP, this, 86);
        this.add(noclip);
        noclip.setEnabled(false);
        this.addSeparator();
        JMenu jMenu = new JMenu("Flip");
        this.add(jMenu);
        jMenu.setMnemonic(70);
        jMenu.add(IPUtils.getMI(this.FLIP_V, this, 86));
        jMenu.add(IPUtils.getMI(this.FLIP_H, this, 72));
        jMenu = new JMenu("Mirror");
        this.add(jMenu);
        jMenu.setMnemonic(77);
        jMenu.add(IPUtils.getMI(this.NORTH, this, 78));
        jMenu.add(IPUtils.getMI(this.WEST, this, 87));
        jMenu.add(IPUtils.getMI(this.TILE, this, 84));
        this.addSeparator();
        clip = IPUtils.getMI(this.REPEAT, this, 82);
        this.add(clip);
        this.add(IPUtils.getMI(this.CLONE, this, 79));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Status.clear();
        String string = actionEvent.getActionCommand();
        if (string == this.CLIP) {
            Status.set("Click and drag on grid to define clipping area", 20);
        } else if (string == this.NOCLIP) {
            CrissCross.clip = false;
            CrissCross.handle.repaint();
            noclip.setEnabled(false);
            clip.setEnabled(true);
        } else if (string == this.CUT) {
            Status.set("Click and drag on grid to define area to cut", 15);
        } else if (string == this.COPY) {
            Status.set("Click and drag on grid to define area to copy", 16);
        } else if (string == this.PASTE) {
            Status.set("Click on top left hand corner of paste area or drag to define", 17);
        } else if (string == this.CROP) {
            Status.set("Click and drag on grid to define area to crop", 22);
        } else if (string == this.CLONE) {
            IconPainter.cloneAdd();
        } else if (string == this.REPEAT) {
            Status.set("Click and drag on grid to define area to repeat", 23);
        } else if (string == this.FLIP_H) {
            IconPainter.startAdd();
            BufferedImage bufferedImage = IconPainter.curr;
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n = IconPainter.cols;
            int n2 = IconPainter.rows;
            graphics2D.drawImage(bufferedImage, n, 0, 0, n2, 0, 0, n, n2, null);
            IconPainter.refreshAll();
        } else if (string == this.FLIP_V) {
            IconPainter.startAdd();
            BufferedImage bufferedImage = IconPainter.curr;
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n = IconPainter.cols;
            int n3 = IconPainter.rows;
            graphics2D.drawImage(bufferedImage, 0, n3, n, 0, 0, 0, n, n3, null);
            IconPainter.refreshAll();
        } else {
            IconPainter.startAdd();
            BufferedImage bufferedImage = IconPainter.curr;
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n = IconPainter.cols;
            int n4 = IconPainter.rows;
            int n5 = n / 2;
            int n6 = n4 / 2;
            if (string == this.NORTH) {
                graphics2D.drawImage(bufferedImage, 0, n4, n, n4 - n6, 0, 0, n, n6, null);
            } else if (string == this.WEST) {
                graphics2D.drawImage(bufferedImage, n, 0, n - n5, n4, 0, 0, n5, n4, null);
            } else if (string == this.TILE) {
                graphics2D.drawImage(bufferedImage, n, 0, n - n5, n4 - n6, 0, 0, n5, n6, null);
                graphics2D.drawImage(bufferedImage, 0, n4, n - n5, n4 - n6, 0, 0, n5, n6, null);
                graphics2D.drawImage(bufferedImage, n, n4, n - n5, n4 - n6, 0, 0, n5, n6, null);
            }
            IconPainter.refreshAll();
        }
    }

    static void off() {
        clip.setEnabled(true);
        noclip.setEnabled(false);
        CrissCross.clip = false;
    }

    static void on() {
        clip.setEnabled(false);
        noclip.setEnabled(true);
    }
}

