/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Anih;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.SysProps;
import com.equitysoft.icon.ValueAdjuster;
import com.equitysoft.icon.ValueBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DefineRate
extends IPDialog
implements ActionListener,
ValueAdjuster,
ListSelectionListener {
    static int[] result;
    String APPLY = "Apply";
    String CANCEL = "Cancel";
    Anih curr;
    DefaultListModel ratevals;
    ValueBox vb;
    JList list;
    int currpos;
    ABox[] aboxes;
    ABox currbox;

    DefineRate(Anih anih) {
        super("");
        int n;
        this.resetTitle();
        this.curr = anih;
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane.getViewport().add(jPanel);
        this.jp.add((Component)jScrollPane, "North");
        int n2 = anih.num;
        this.aboxes = new ABox[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.aboxes[n3] = new ABox(anih.imgs[n3], n3);
            jPanel.add(this.aboxes[n3]);
            ++n3;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rates"));
        JScrollPane jScrollPane2 = new JScrollPane();
        this.ratevals = new DefaultListModel();
        this.list = new JList();
        this.list.setFont(SysProps.MSG_FONT);
        jScrollPane2.setPreferredSize(new Dimension(80, 100));
        this.list.setModel(this.ratevals);
        this.list.setSelectedIndex(0);
        this.list.setSelectionMode(0);
        jScrollPane2.getViewport().setView(this.list);
        if (anih.rate == null) {
            n = 0;
            while (n < anih.num) {
                this.ratevals.addElement(" No." + (n + 1) + ": " + 10);
                ++n;
            }
        } else {
            n = 0;
            while (n < anih.num) {
                this.ratevals.addElement(" No." + (n + 1) + ": " + anih.rate[n]);
                ++n;
            }
        }
        this.list.addListSelectionListener(this);
        jPanel3.add(jScrollPane2);
        jPanel2.add(jPanel3);
        this.vb = new ValueBox("Rate (jiffies)", 1, 1, 1000, this);
        jPanel2.add(this.vb);
        this.jp.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        LibButton libButton = new LibButton(this.APPLY);
        jPanel4.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.CANCEL);
        jPanel4.add(libButton);
        libButton.addActionListener(this);
        this.jp.add((Component)jPanel4, "South");
        this.currpos = 0;
        this.currbox = this.aboxes[0];
        this.currbox.entered = true;
        if (anih.rate == null) {
            this.vb.set(10);
        } else {
            this.vb.set(anih.rate[0]);
        }
        this.finishOff();
        this.currbox.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CANCEL) {
            this.closeDialog();
        } else if (string == this.APPLY) {
            int n = this.ratevals.getSize();
            if (n == 0) {
                this.closeDialog();
                new IPZap("Ignored - the list of rates was empty");
                return;
            }
            result = new int[n];
            int n2 = 0;
            while (n2 < n) {
                DefineRate.result[n2] = this.convert((String)this.ratevals.getElementAt(n2));
                ++n2;
            }
        }
        this.closeDialog();
    }

    int convert(String string) {
        int n = string.indexOf(58);
        return Integer.parseInt(string.substring(n + 2));
    }

    static int[] getRate(Anih anih) {
        result = null;
        new DefineRate(anih);
        return result;
    }

    void resetTitle() {
        this.setTitle(" Frame " + (this.currpos + 1) + " selected");
    }

    public void setValue(ValueBox valueBox, int n) {
        this.ratevals.setElementAt(" No." + (this.currpos + 1) + ": " + n, this.currpos);
    }

    void tempTitle(int n) {
        this.setTitle(" Frame " + (n + 1) + " of " + this.curr.num);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.currpos = this.list.getSelectedIndex();
        this.vb.set(this.convert((String)this.ratevals.getElementAt(this.currpos)));
        ABox aBox = this.currbox;
        this.currbox = this.aboxes[this.currpos];
        aBox.entered = false;
        aBox.repaint();
        this.currbox.entered = true;
        this.currbox.repaint();
        this.resetTitle();
    }

    class ABox
    extends JPanel {
        BufferedImage bi;
        boolean entered;
        boolean pressed;
        int num;

        ABox(BufferedImage bufferedImage, int n) {
            this.enableEvents(16L);
            this.bi = bufferedImage;
            this.num = n;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.bi.getWidth() + 6, this.bi.getHeight() + 6);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getPreferredSize();
            int n = dimension.width - 3;
            int n2 = dimension.height - 3;
            if (this.entered) {
                if (DefineRate.this.currbox != this) {
                    graphics2D.setColor(Color.green);
                } else {
                    graphics2D.setColor(Color.orange);
                }
                graphics2D.fillRect(0, 0, dimension.width, 3);
                graphics2D.fillRect(n, 0, 3, dimension.height);
                graphics2D.fillRect(0, n2, dimension.width, 3);
                graphics2D.fillRect(0, 0, 3, dimension.height);
                if (DefineRate.this.currbox != this) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(Color.blue);
                }
                int n3 = 0;
                while (n3 < dimension.width) {
                    graphics2D.fillRect(n3, 0, 4, 3);
                    graphics2D.fillRect(n3, n2, 4, 3);
                    n3 += 8;
                }
                n3 = 0;
                while (n3 < dimension.height) {
                    graphics2D.fillRect(0, n3, 3, 4);
                    graphics2D.fillRect(n, n3, 3, 4);
                    n3 += 8;
                }
            } else {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            }
            graphics2D.drawImage((Image)this.bi, 3, 3, null);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 504: {
                    if (DefineRate.this.currbox == this) {
                        return;
                    }
                    DefineRate.this.tempTitle(this.num);
                    this.entered = true;
                    this.repaint();
                    break;
                }
                case 505: {
                    if (DefineRate.this.currbox == this) {
                        return;
                    }
                    DefineRate.this.resetTitle();
                    this.entered = false;
                    this.repaint();
                    break;
                }
                case 501: {
                    if (DefineRate.this.currbox != this) {
                        ABox aBox = null;
                        if (DefineRate.this.currbox != null) {
                            aBox = DefineRate.this.currbox;
                        }
                        DefineRate.this.currbox = this;
                        if (aBox != null) {
                            aBox.entered = false;
                            aBox.repaint();
                            DefineRate.this.list.setSelectedIndex(this.num);
                            DefineRate.this.list.ensureIndexIsVisible(this.num);
                            DefineRate.this.currpos = this.num;
                            DefineRate.this.vb.set(DefineRate.this.convert((String)DefineRate.this.ratevals.getElementAt(this.num)));
                        }
                        this.repaint();
                        DefineRate.this.resetTitle();
                        break;
                    }
                    this.entered = false;
                    DefineRate.this.currbox = null;
                    this.repaint();
                    DefineRate.this.tempTitle(this.num);
                }
            }
        }
    }
}

