/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.Dummy;
import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.LibButton;
import com.equitysoft.icon.SwingToolButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

class CutImage
extends IPDialog
implements ActionListener {
    static Dimension DIM = new Dimension(25, 25);
    static final Cursor CROSSHAIR = new Cursor(1);
    static String ORIG = "Drag the cursor to mark area to cut";
    String CUT = "Cut & overlay";
    String RESIZE = "Cut & resize";
    String CANCEL = "Cancel";
    String NOBOX = "Draw a box first";
    Image img;
    Dimension pdim;
    boolean boxonscreen;
    int action;
    int origx;
    int origy;
    int currx;
    int curry;
    int prevx;
    int prevy;
    int prevxdiff;
    int prevydiff;
    int xdiff;
    int ydiff;
    int xtop;
    int ytop;
    StringBuffer sb = new StringBuffer(50);
    JRadioButton origin;
    JRadioButton border;
    boolean overlay;
    CutImage handle;
    CenterPanel center;

    CutImage(Image image, boolean bl) {
        super(ORIG);
        this.overlay = bl;
        this.img = image;
        this.handle = this;
        this.jp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.pdim = new Dimension(image.getWidth(null), image.getHeight(null));
        jPanel.setLayout(new FlowLayout());
        ControlPanel controlPanel = new ControlPanel();
        jPanel.add(controlPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.border = new JRadioButton("Adjust box dimension");
        jPanel2.add((Component)this.border, "North");
        buttonGroup.add(this.border);
        this.border.setSelected(true);
        this.origin = new JRadioButton("Adjust box origin");
        jPanel2.add((Component)this.origin, "South");
        buttonGroup.add(this.origin);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        if (!bl) {
            this.CUT = "Cut out";
        }
        LibButton libButton = new LibButton(this.CUT);
        jPanel2.add((Component)libButton, "North");
        libButton.addActionListener(this);
        if (bl) {
            libButton = new LibButton(this.RESIZE);
            jPanel2.add((Component)libButton, "Center");
            libButton.addActionListener(this);
        }
        libButton = new LibButton(this.CANCEL);
        jPanel2.add((Component)libButton, "South");
        libButton.addActionListener(this);
        jPanel.add(jPanel2);
        this.jp.add((Component)jPanel, "North");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.center = new CenterPanel();
        jScrollPane.getViewport().add(this.center);
        this.jp.add((Component)jScrollPane, "Center");
        this.finishOff();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CUT) {
            if (!this.boxonscreen) {
                this.setTitle(this.NOBOX);
                return;
            }
            this.closeDialog();
            IconPainter.startAdd();
            int n = this.xdiff - 1;
            int n2 = this.ydiff - 1;
            if (n < 1 || n2 < 1) {
                new IPZap("Zero height or width can't be used");
                return;
            }
            int n3 = this.xtop + 1;
            int n4 = this.ytop + 1;
            if (this.overlay) {
                Graphics2D graphics2D = IconPainter.transimg.createGraphics();
                int n5 = (IconPainter.cols - n) / 2;
                int n6 = (IconPainter.rows - n2) / 2;
                graphics2D.drawImage(this.img, n5, n6, n5 + n, n6 + n2, n3, n4, n3 + n, n4 + n2, null, null);
                IPLib.paintTransImg();
            } else {
                if (IconPainter.sqdim != 1 && (n * IconPainter.sqdim > IconPainter.screendim.width || n2 * IconPainter.sqdim > IconPainter.screendim.height)) {
                    new IPZap("The grid size will be too big, change the square size and retry");
                    return;
                }
                IconPainter.init(n, n2);
                Graphics2D graphics2D = IconPainter.curr.createGraphics();
                graphics2D.drawImage(this.img, 0, 0, n, n2, n3, n4, n3 + n, n4 + n2, null);
                Bar.setUntitled();
            }
        } else if (string == this.RESIZE) {
            if (!this.boxonscreen) {
                this.setTitle(this.NOBOX);
                return;
            }
            this.closeDialog();
            IconPainter.startAdd();
            Graphics2D graphics2D = IconPainter.transimg.createGraphics();
            graphics2D.drawImage(this.img, 0, 0, IconPainter.cols, IconPainter.rows, this.xtop, this.ytop, this.xtop + this.xdiff, this.ytop + this.ydiff, null);
            IPLib.paintTransImg();
        } else {
            this.closeDialog();
        }
    }

    void set(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - 1;
        if (n6 < 1) {
            n6 = 0;
        }
        if ((n5 = n3 - 1) < 1) {
            n5 = 0;
        }
        this.sb.setLength(0);
        this.sb.append(" X: ").append(n + 1).append("  Y: ").append(n2 + 1).append("  Wid: ").append(n5).append("  Hgt: ").append(n6);
        this.setTitle(this.sb.toString());
    }

    void setPoint(int n, int n2) {
        this.sb.setLength(0);
        this.sb.append(" X: ").append(n).append("  Y: ").append(n2);
        this.setTitle(this.sb.toString());
    }

    class ControlPanel
    extends JPanel
    implements ActionListener {
        Dimension DIM = new Dimension(25, 25);
        SwingToolButton up;
        SwingToolButton right;
        SwingToolButton down;
        SwingToolButton left;

        ControlPanel() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
            this.setLayout(new GridLayout(3, 3));
            this.add(new Dummy());
            this.up = this.getButton("up.gif", "Shift up");
            this.add(this.up);
            this.up.addActionListener(this);
            this.add(new JLabel());
            this.left = this.getButton("left.gif", "Shift left");
            this.add(this.left);
            this.add(new JLabel());
            this.right = this.getButton("right.gif", "Shift right");
            this.add(this.right);
            this.add(new JLabel());
            this.down = this.getButton("down.gif", "Shift down");
            this.add(this.down);
            this.add(new JLabel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!CutImage.this.boxonscreen) {
                CutImage.this.handle.setTitle(CutImage.this.NOBOX);
                return;
            }
            SwingToolButton swingToolButton = (SwingToolButton)actionEvent.getSource();
            Graphics graphics = CutImage.this.center.getGraphics();
            graphics.setXORMode(CrissCross.XOR_COLOR);
            graphics.drawRect(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
            if (CutImage.this.origin.isSelected()) {
                if (swingToolButton == this.left) {
                    --CutImage.this.xtop;
                } else if (swingToolButton == this.right) {
                    ++CutImage.this.xtop;
                } else if (swingToolButton == this.up) {
                    --CutImage.this.ytop;
                } else if (swingToolButton == this.down) {
                    ++CutImage.this.ytop;
                }
            } else if (swingToolButton == this.left) {
                --CutImage.this.xdiff;
            } else if (swingToolButton == this.right) {
                ++CutImage.this.xdiff;
            } else if (swingToolButton == this.up) {
                --CutImage.this.ydiff;
            } else if (swingToolButton == this.down) {
                ++CutImage.this.ydiff;
            }
            graphics.drawRect(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
            graphics.dispose();
            CutImage.this.set(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
        }

        SwingToolButton getButton(String string, String string2) {
            Image image = IPUtils.getSystemImage(string);
            return new SwingToolButton(image, string2, this.DIM, this, null);
        }
    }

    class CenterPanel
    extends JPanel {
        CenterPanel() {
            this.enableEvents(48L);
        }

        public Dimension getPreferredSize() {
            return CutImage.this.pdim;
        }

        public void paintComponent(Graphics graphics) {
            graphics.drawImage(CutImage.this.img, 0, 0, null);
            if (CutImage.this.boxonscreen) {
                graphics.setXORMode(CrissCross.XOR_COLOR);
                graphics.drawRect(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
                graphics.setPaintMode();
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    CutImage.this.prevx = mouseEvent.getX();
                    CutImage.this.prevy = mouseEvent.getY();
                    CutImage.this.setPoint(CutImage.this.prevx, CutImage.this.prevy);
                    if (CutImage.this.boxonscreen) {
                        CutImage.this.boxonscreen = false;
                        Graphics graphics = this.getGraphics();
                        graphics.setXORMode(CrissCross.XOR_COLOR);
                        graphics.drawRect(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
                        graphics.dispose();
                    }
                    CutImage.this.origx = CutImage.this.prevx;
                    CutImage.this.origy = CutImage.this.prevy;
                    CutImage.this.currx = CutImage.this.origx;
                    CutImage.this.curry = CutImage.this.origy;
                    CutImage.this.xtop = CutImage.this.origx;
                    CutImage.this.ytop = CutImage.this.origy;
                    CutImage.this.xdiff = 0;
                    CutImage.this.ydiff = 0;
                    CutImage.this.prevxdiff = 0;
                    CutImage.this.prevydiff = 0;
                    break;
                }
                case 502: {
                    if (CutImage.this.boxonscreen) break;
                    CutImage.this.handle.setTitle(ORIG);
                    break;
                }
                case 504: {
                    this.setCursor(CROSSHAIR);
                    break;
                }
                case 505: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
            }
            super.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 506: {
                    CutImage.this.curry = mouseEvent.getY();
                    CutImage.this.currx = mouseEvent.getX();
                    Graphics graphics = this.getGraphics();
                    graphics.setXORMode(CrissCross.XOR_COLOR);
                    if (!CutImage.this.boxonscreen) {
                        CutImage.this.boxonscreen = true;
                        graphics.drawLine(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xtop, CutImage.this.ytop);
                    }
                    CutImage.this.prevx = CutImage.this.xtop;
                    CutImage.this.prevy = CutImage.this.ytop;
                    CutImage.this.prevxdiff = CutImage.this.xdiff;
                    CutImage.this.prevydiff = CutImage.this.ydiff;
                    if (CutImage.this.curry < CutImage.this.origy) {
                        CutImage.this.ytop = CutImage.this.curry;
                        CutImage.this.ydiff = CutImage.this.origy - CutImage.this.curry;
                    } else {
                        CutImage.this.ytop = CutImage.this.origy;
                        CutImage.this.ydiff = CutImage.this.curry - CutImage.this.origy;
                    }
                    if (CutImage.this.currx < CutImage.this.origx) {
                        CutImage.this.xtop = CutImage.this.currx;
                        CutImage.this.xdiff = CutImage.this.origx - CutImage.this.currx;
                    } else {
                        CutImage.this.xtop = CutImage.this.origx;
                        CutImage.this.xdiff = CutImage.this.currx - CutImage.this.origx;
                    }
                    graphics.drawRect(CutImage.this.prevx, CutImage.this.prevy, CutImage.this.prevxdiff, CutImage.this.prevydiff);
                    graphics.drawRect(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
                    graphics.dispose();
                    CutImage.this.set(CutImage.this.xtop, CutImage.this.ytop, CutImage.this.xdiff, CutImage.this.ydiff);
                    break;
                }
            }
            super.processMouseMotionEvent(mouseEvent);
        }
    }
}

