/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.IPDialog;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.ImageEffect;
import com.equitysoft.icon.LibButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.Kernel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CustomConvolve
extends IPDialog
implements ActionListener {
    String APPLY = "Apply";
    String RESET = "Reset";
    String CANCEL = "Cancel";
    int size;
    JTextField[] vals;
    int num;

    CustomConvolve(String string) {
        super("Custom convolve");
        this.size = string.startsWith("3") ? 3 : 5;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        LibButton libButton = new LibButton(this.APPLY);
        jPanel.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.RESET);
        jPanel.add(libButton);
        libButton.addActionListener(this);
        libButton = new LibButton(this.CANCEL);
        jPanel.add(libButton);
        libButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(this.size, this.size));
        this.num = this.size * this.size;
        this.vals = new JTextField[this.num];
        int n = 0;
        while (n < this.num) {
            this.vals[n] = new JTextField(5);
            this.vals[n].setText("0");
            jPanel3.add(this.vals[n]);
            ++n;
        }
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add(jPanel3);
        this.finishOff();
        this.vals[0].requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.CANCEL) {
            ((Component)this).setVisible(false);
            ImageEffect.handle.repaint();
        } else if (string == this.RESET) {
            int n = 0;
            while (n < this.num) {
                this.vals[n].setText("0");
                this.vals[n].setEditable(true);
                ++n;
            }
        } else {
            float[] fArray = new float[this.num];
            boolean bl = true;
            int n = 0;
            while (n < this.num) {
                if (this.vals[n].equals("0")) {
                    this.vals[n].setText("0");
                }
                this.vals[n].repaint();
                this.vals[n].setEditable(false);
                try {
                    fArray[n] = Float.valueOf(this.vals[n].getText()).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    this.vals[n].setEditable(true);
                }
                ++n;
            }
            if (bl) {
                ((Component)this).setVisible(false);
                ImageEffect.handle.repaint();
                ImageEffect.applyConvolve(new Kernel(this.size, this.size, fArray), false);
            } else {
                int n2 = 0;
                while (n2 < this.num) {
                    if (this.vals[n2].isEditable()) {
                        this.vals[n2].requestFocus();
                        break;
                    }
                    ++n2;
                }
                new IPZap("All values should be numbers");
            }
        }
    }
}

