/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.CopyPaste;
import com.equitysoft.icon.EditMenu;
import com.equitysoft.icon.Grid;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.ISave;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.InfoBar;
import com.equitysoft.icon.Palette;
import com.equitysoft.icon.ShapeMenu;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.XPMCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.util.Vector;

class CrissCross
extends Component {
    static final int INSET = 10;
    static final int NORMAL = 0;
    static double trisin;
    static double tricos;
    static double trisin2;
    static double tricos2;
    static QuadCurve2D.Float quadcurve;
    static CubicCurve2D.Float cubiccurve;
    static Vector points;
    static Point[] controls;
    static Rectangle[] boxes;
    static int idx;
    static int currbox;
    static int xoff;
    static int yoff;
    static Color XOR_COLOR;
    static int origx;
    static int origy;
    static int currx;
    static int curry;
    static int prevx;
    static int prevy;
    static int prevxdiff;
    static int prevydiff;
    static int xdiff;
    static int ydiff;
    static int xtop;
    static int ytop;
    static BufferedImage curr;
    static boolean lineonscreen;
    static boolean clip;
    static int clipx;
    static int clipy;
    static int clipxoff;
    static int clipyoff;
    static boolean tracking;
    static int prevdrag;
    static int rows;
    static int cols;
    static int sqdim;
    static int wminus1;
    static int hminus1;
    static int wid;
    static int hgt;
    static Color lines;
    boolean dragging;
    boolean ignoreclick;
    boolean showcenter;
    static final int DASH = 4;
    static final int DOUBLE = 8;
    static CrissCross handle;
    static int dragx;
    static int dragy;

    static {
        points = new Vector();
        XOR_COLOR = new Color(0, 150, 150);
    }

    CrissCross() {
        this.enableEvents(48L);
        handle = this;
        prevdrag = -1;
        dragx = -1;
        dragy = -1;
    }

    static void drawBoxes(Graphics graphics) {
        int n = 0;
        while (n < idx) {
            Rectangle rectangle = boxes[n];
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
    }

    void drawSegment(int n, int n2) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(XOR_COLOR);
        graphics.drawLine(origx, origy, prevx, prevy);
        graphics.drawLine(origx, origy, n, n2);
        prevx = n;
        prevy = n2;
        graphics.dispose();
    }

    void endPaint() {
        IPLib.paintTransImg();
        IconPainter.refreshAll();
        Status.clear();
    }

    public Dimension getPreferredSize() {
        return sqdim > 0 ? new Dimension(IconPainter.cols * IconPainter.sqdim, IconPainter.rows * IconPainter.sqdim) : new Dimension(cols, rows);
    }

    static void initCurve() {
        int n = rows * sqdim / 2;
        int n2 = cols * sqdim / 2;
        Point point = controls[0];
        point.x = 11;
        point.y = n;
        if (Status.action == 32) {
            if (quadcurve == null) {
                quadcurve = new QuadCurve2D.Float();
            }
            point = controls[1];
            point.x = n2;
            point.y = rows * sqdim - 10 - 1;
            point = controls[2];
            point.x = cols * sqdim - 10 - 1;
            point.y = n;
        } else {
            if (cubiccurve == null) {
                cubiccurve = new CubicCurve2D.Float();
            }
            int n3 = cols * sqdim / 4;
            int n4 = rows * sqdim / 3;
            point = controls[1];
            point.x = n3;
            point.y = n4;
            point = controls[2];
            point.x = n2 + n3;
            point.y = n4 + n4;
            point = controls[3];
            point.x = cols * sqdim - 10 - 1;
            point.y = n;
        }
        CrissCross.updateBoxes();
        CrissCross.paintCurve();
    }

    static void initTriangle() {
        trisin = Math.sin(2.0943951023931953);
        tricos = Math.cos(2.0943951023931953);
        trisin2 = Math.sin(4.1887902047863905);
        tricos2 = Math.cos(4.1887902047863905);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        graphics.setColor(IconPainter.backcol);
        graphics.fillRect(0, 0, wid, hgt);
        if (sqdim > 1) {
            n5 = 0;
            n4 = 0;
            n3 = 0;
            while (n3 < rows) {
                n2 = 0;
                while (n2 < cols) {
                    graphics.setColor(new Color(curr.getRGB(n2, n3)));
                    graphics.fillRect(n4, n5, sqdim, sqdim);
                    ++n2;
                    n4 += sqdim;
                }
                ++n3;
                n5 += sqdim;
                n4 = 0;
            }
            graphics.setColor(lines);
            n2 = 0;
            n = 0;
            while (n < cols) {
                graphics.drawLine(n2, 0, n2, hgt);
                n2 += sqdim;
                ++n;
            }
            graphics.drawLine(n2, 0, n2, hgt);
            n2 = 0;
            n = 0;
            while (n < rows) {
                graphics.drawLine(0, n2, wid, n2);
                n2 += sqdim;
                ++n;
            }
            graphics.drawLine(0, n2, wid, n2);
        } else {
            graphics.drawImage(curr, 0, 0, null);
        }
        if (this.showcenter) {
            n = wid / 2;
            n5 = hgt / 2;
            if (IconPainter.sqdim > 1) {
                ++n;
                ++n5;
            }
            graphics.setClip(0, 0, wid, hgt);
            graphics.setXORMode(Color.red);
            graphics.drawLine(0, n5, wid, n5);
            graphics.drawLine(n, 0, n, hgt);
            graphics.setXORMode(Color.green);
            n4 = 0;
            while (n4 < wid) {
                graphics.drawLine(n4, n5, n4 + 3, n5);
                n4 += 6;
            }
            n3 = 0;
            while (n3 < hgt) {
                graphics.drawLine(n, n3, n, n3 + 3);
                n3 += 6;
            }
        }
        if (clip) {
            n = clipx * sqdim + 1;
            n5 = clipy * sqdim + 1;
            n4 = n + clipxoff * sqdim;
            n3 = n5 + clipyoff * sqdim;
            graphics.setClip(0, 0, n4, n3);
            graphics.setXORMode(Color.blue);
            n2 = n;
            while (n2 < n4) {
                graphics.drawLine(n2, n5, n2 + 4, n5);
                graphics.drawLine(n2, n3, n2 + 4, n3);
                n2 += 8;
            }
            int n6 = n5;
            while (n6 < n3) {
                graphics.drawLine(n, n6, n, n6 + 4);
                graphics.drawLine(n4, n6, n4, n6 + 4);
                n6 += 8;
            }
        }
    }

    static void paintCurve() {
        Graphics2D graphics2D = (Graphics2D)handle.getGraphics();
        graphics2D.setXORMode(XOR_COLOR);
        if (Status.action == 32) {
            quadcurve.setCurve(controls, 0);
            graphics2D.draw(quadcurve);
        } else {
            cubiccurve.setCurve(controls, 0);
            graphics2D.draw(cubiccurve);
        }
        CrissCross.drawBoxes(graphics2D);
        graphics2D.dispose();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                prevx = mouseEvent.getX();
                prevy = mouseEvent.getY();
                int n = prevx / sqdim;
                int n2 = prevy / sqdim;
                if (n >= cols || n2 >= rows) {
                    return;
                }
                Grid.setPos(n, n2);
                if (Status.action >= 30) {
                    if (!tracking) {
                        IconPainter.startAdd();
                        tracking = true;
                    }
                    switch (Status.action) {
                        case 30: 
                        case 31: 
                        case 34: {
                            if (prevx == origx && prevy == origy) {
                                return;
                            }
                            prevx = origx = mouseEvent.getX();
                            prevy = origy = mouseEvent.getY();
                            points.addElement(new Point(n, n2));
                            break;
                        }
                        case 32: 
                        case 33: {
                            int n3 = 0;
                            while (n3 < idx) {
                                if (boxes[n3].contains(prevx, prevy)) break;
                                ++n3;
                            }
                            if (n3 == idx) {
                                currbox = -1;
                                break;
                            }
                            currbox = n3;
                            xoff = prevx - CrissCross.boxes[n3].x;
                            yoff = prevy - CrissCross.boxes[n3].y;
                        }
                    }
                    return;
                }
                IconPainter.startAdd();
                origx = prevx;
                origy = prevy;
                currx = origx;
                curry = origy;
                xtop = origx;
                ytop = origy;
                xdiff = 0;
                ydiff = 0;
                prevxdiff = 0;
                prevydiff = 0;
                break;
            }
            case 500: {
                switch (Status.action) {
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        int n = mouseEvent.getX() / sqdim;
                        int n4 = mouseEvent.getY() / sqdim;
                        if (n >= cols || n4 >= rows) {
                            return;
                        }
                        if (mouseEvent.getClickCount() > 1) {
                            switch (Status.action) {
                                case 30: 
                                case 34: {
                                    ShapeMenu.saveShape(points);
                                    points.clear();
                                    break;
                                }
                                case 31: {
                                    IPLib.drawMPLine(points);
                                    points.clear();
                                    break;
                                }
                                case 32: 
                                case 33: {
                                    IPLib.drawCurve(Status.action, idx);
                                    break;
                                }
                            }
                            this.endPaint();
                            tracking = false;
                            Grid.setOrig();
                        }
                        return;
                    }
                    case -1: {
                        Status.clear();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 502: {
                int n = mouseEvent.getX() / sqdim;
                int n5 = mouseEvent.getY() / sqdim;
                int n6 = Status.action;
                switch (n6) {
                    case 17: {
                        CopyPaste.clickPaste(mouseEvent.getX() / sqdim, mouseEvent.getY() / sqdim);
                        this.ignoreclick = true;
                        return;
                    }
                    case 5: 
                    case 6: {
                        if (curr.getRGB(n, n5) != Palette.currcolor) {
                            if (n6 == 5) {
                                if (!IPLib.floodFill(curr.getRGB(n, n5), n, n5)) {
                                    return;
                                }
                            } else {
                                IPLib.saturate(curr.getRGB(n, n5));
                            }
                            IPLib.fillWithGradient();
                            IPLib.paintTransImg();
                        } else {
                            new IPZap("Ignored - the color clicked is already the target color");
                        }
                        Status.clear();
                        return;
                    }
                    case 4: {
                        Palette.currcolor = curr.getRGB(n, n5);
                        InfoBar.set();
                        Status.clear();
                        return;
                    }
                    case 18: {
                        Palette.targcol = curr.getRGB(n, n5);
                        InfoBar.set();
                        Status.clear();
                        return;
                    }
                    case 19: {
                        IconPainter.resetBack(new Color(curr.getRGB(n, n5)));
                        Status.clear();
                        return;
                    }
                    case 14: {
                        ISave.setSpot(n, n5);
                        Status.clear();
                        return;
                    }
                    case 21: {
                        XPMCreator.setSpot(n, n5);
                        Status.clear();
                        return;
                    }
                }
                if (tracking) {
                    return;
                }
                if (this.dragging) {
                    this.dragging = false;
                    lineonscreen = false;
                    dragx = -1;
                    dragy = -1;
                    switch (n6) {
                        case 8: {
                            IPLib.drawShape(origx / sqdim, origy / sqdim, currx / sqdim, curry / sqdim, Status.action);
                            break;
                        }
                        case 7: 
                        case 9: 
                        case 15: 
                        case 16: 
                        case 20: 
                        case 22: 
                        case 23: {
                            ydiff = curry < origy ? origy / sqdim - curry / sqdim : curry / sqdim - origy / sqdim;
                            xdiff = currx < origx ? origx / sqdim - currx / sqdim : currx / sqdim - origx / sqdim;
                            if (n6 == 15 || n6 == 16 || n6 == 17 || n6 == 23) {
                                if (xtop / sqdim + xdiff > cols) {
                                    xdiff = cols - xtop / sqdim;
                                }
                                if (ytop / sqdim + ydiff > rows) {
                                    ydiff = rows - ytop / sqdim;
                                }
                                if (xdiff < 1 || ydiff < 1) {
                                    this.repaint();
                                    return;
                                }
                                CopyPaste.apply(xtop / sqdim, ytop / sqdim, xdiff, ydiff, Status.action);
                                return;
                            }
                            if (n6 == 20) {
                                if (xtop < 0) {
                                    xtop = 0;
                                }
                                if (ytop < 0) {
                                    ytop = 0;
                                }
                                clipx = xtop / sqdim;
                                clipy = ytop / sqdim;
                                if (clipx + xdiff > cols) {
                                    xdiff = cols - clipx - 1;
                                }
                                if (clipy + ydiff > rows) {
                                    ydiff = rows - clipy - 1;
                                }
                                clipxoff = xdiff + 1;
                                clipyoff = ydiff + 1;
                                if (xdiff < 1 || ydiff < 2) {
                                    this.repaint();
                                    return;
                                }
                                clip = true;
                                this.repaint();
                                EditMenu.on();
                                break;
                            }
                            if (n6 == 22) {
                                if (xtop < 0) {
                                    xtop = 0;
                                }
                                if (ytop < 0) {
                                    ytop = 0;
                                }
                                if (xtop / sqdim + xdiff > cols) {
                                    xdiff = cols - xtop / sqdim;
                                }
                                if (ytop / sqdim + ydiff > rows) {
                                    ydiff = rows - ytop / sqdim;
                                }
                                if (xdiff < 1 || ydiff < 1) {
                                    this.repaint();
                                    return;
                                }
                                CopyPaste.crop(xtop / sqdim, ytop / sqdim, xdiff, ydiff);
                                return;
                            }
                            IPLib.drawShape(xtop / sqdim, ytop / sqdim, xdiff, ydiff, Status.action);
                            break;
                        }
                        case 10: {
                            int n7 = origx / sqdim;
                            int n8 = origy / sqdim;
                            xdiff = n7 - currx / sqdim;
                            ydiff = n8 - curry / sqdim;
                            int n9 = (int)Math.round(Math.sqrt(xdiff * xdiff + ydiff * ydiff));
                            IPLib.drawShape(n7 - n9, n8 - n9, n9 + n9, n9 + n9, Status.action);
                            break;
                        }
                        case 11: {
                            int[] nArray = new int[3];
                            int[] nArray2 = new int[3];
                            nArray[0] = currx / sqdim;
                            nArray2[0] = curry / sqdim;
                            nArray[1] = xtop / sqdim;
                            nArray2[1] = ytop / sqdim;
                            nArray[2] = prevx / sqdim;
                            nArray2[2] = prevy / sqdim;
                            IPLib.drawPoly(nArray, nArray2);
                            break;
                        }
                    }
                    Status.action = 0;
                } else {
                    switch (Status.action) {
                        case 7: {
                            IPLib.drawShape(0, 0, IconPainter.cols - 1, IconPainter.rows - 1, 7);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 20: {
                            Status.action = -1;
                            return;
                        }
                        default: {
                            Graphics graphics = this.getGraphics();
                            IconPainter.transimg.setRGB(n, n5, Palette.currcolor);
                            graphics.setColor(new Color(Palette.currcolor));
                            graphics.fillRect(n * sqdim + 1, n5 * sqdim + 1, sqdim - 1, sqdim - 1);
                            graphics.dispose();
                        }
                    }
                }
                this.endPaint();
                break;
            }
            case 505: {
                Grid.setOrig();
                return;
            }
            default: {
                return;
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = Status.action;
        int n4 = n / sqdim;
        int n5 = n2 / sqdim;
        boolean bl = false;
        if (n4 >= cols || n5 >= rows || n4 < 0 || n5 < 0) {
            Grid.setOrig();
            bl = true;
        } else {
            Grid.setPos(n4, n5);
        }
        if (mouseEvent.getID() == 506) {
            this.dragging = true;
            switch (n3) {
                case 4: 
                case 5: 
                case 6: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 21: {
                    return;
                }
                case 30: 
                case 31: 
                case 34: {
                    this.drawSegment(n, n2);
                    break;
                }
                case 32: 
                case 33: {
                    if (currbox < 0) {
                        return;
                    }
                    CrissCross.paintCurve();
                    Rectangle rectangle = boxes[currbox];
                    rectangle.x = n - xoff;
                    rectangle.y = n2 - yoff;
                    Point point = controls[currbox];
                    point.x = rectangle.x + 10;
                    point.y = rectangle.y + 10;
                    CrissCross.paintCurve();
                    break;
                }
                case 7: 
                case 9: 
                case 15: 
                case 16: 
                case 20: 
                case 22: 
                case 23: {
                    curry = n2;
                    currx = n;
                    Graphics graphics = this.getGraphics();
                    graphics.setXORMode(XOR_COLOR);
                    if (!lineonscreen) {
                        lineonscreen = true;
                        graphics.drawLine(xtop, ytop, xtop, ytop);
                    }
                    prevx = xtop;
                    prevy = ytop;
                    prevxdiff = xdiff;
                    prevydiff = ydiff;
                    if (curry < origy) {
                        ytop = curry;
                        ydiff = origy - curry;
                    } else {
                        ytop = origy;
                        ydiff = curry - origy;
                    }
                    if (currx < origx) {
                        xtop = currx;
                        xdiff = origx - currx;
                    } else {
                        xtop = origx;
                        xdiff = currx - origx;
                    }
                    graphics.drawRect(prevx, prevy, prevxdiff, prevydiff);
                    graphics.drawRect(xtop, ytop, xdiff, ydiff);
                    if (Status.action == 9) {
                        graphics.drawArc(prevx + 1, prevy + 1, prevxdiff - 2, prevydiff - 2, 0, 360);
                        graphics.drawArc(xtop + 1, ytop + 1, xdiff - 2, ydiff - 2, 0, 360);
                    }
                    graphics.dispose();
                    break;
                }
                case 8: {
                    curry = n2;
                    currx = n;
                    Graphics graphics = this.getGraphics();
                    graphics.setXORMode(XOR_COLOR);
                    if (!lineonscreen) {
                        lineonscreen = true;
                        graphics.drawLine(origx, origy, origx, origy);
                    }
                    graphics.drawLine(origx, origy, prevx, prevy);
                    graphics.drawLine(origx, origy, currx, curry);
                    prevx = currx;
                    prevy = curry;
                    graphics.dispose();
                    break;
                }
                case 10: {
                    curry = n2;
                    currx = n;
                    Graphics graphics = this.getGraphics();
                    graphics.setXORMode(XOR_COLOR);
                    xdiff = origx - currx;
                    ydiff = origy - curry;
                    prevydiff = (int)Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    xdiff = prevxdiff + prevxdiff;
                    ydiff = prevydiff + prevydiff;
                    if (!lineonscreen) {
                        lineonscreen = true;
                    } else {
                        graphics.drawArc(origx - prevxdiff, origy - prevxdiff, xdiff, xdiff, 0, 360);
                    }
                    graphics.drawArc(origx - prevydiff, origy - prevydiff, ydiff, ydiff, 0, 360);
                    prevxdiff = prevydiff;
                    graphics.dispose();
                    break;
                }
                case 11: {
                    Graphics graphics = this.getGraphics();
                    graphics.setXORMode(XOR_COLOR);
                    if (!lineonscreen) {
                        lineonscreen = true;
                    } else {
                        graphics.drawLine(currx, curry, xtop, ytop);
                        graphics.drawLine(xtop, ytop, prevx, prevy);
                        graphics.drawLine(prevx, prevy, currx, curry);
                    }
                    curry = n2;
                    currx = n;
                    xdiff = n - origx;
                    ydiff = origy - n2;
                    xtop = origx + (int)(tricos * (double)xdiff - (double)ydiff * trisin);
                    ytop = origy - (int)(trisin * (double)xdiff + (double)ydiff * tricos);
                    prevx = origx + (int)(tricos2 * (double)xdiff - (double)ydiff * trisin2);
                    prevy = origy - (int)(trisin2 * (double)xdiff + (double)ydiff * tricos2);
                    graphics.drawLine(n, n2, xtop, ytop);
                    graphics.drawLine(xtop, ytop, prevx, prevy);
                    graphics.drawLine(prevx, prevy, n, n2);
                    graphics.dispose();
                    break;
                }
                default: {
                    if (bl) {
                        return;
                    }
                    if (dragx == n4 & dragy == n5) {
                        return;
                    }
                    dragx = n4;
                    dragy = n5;
                    IconPainter.transimg.setRGB(n4, n5, Palette.currcolor);
                    if (sqdim > 1) {
                        Graphics graphics = this.getGraphics();
                        graphics.setColor(new Color(Palette.currcolor));
                        graphics.fillRect(n4 * sqdim + 1, n5 * sqdim + 1, sqdim - 1, sqdim - 1);
                        graphics.dispose();
                        break;
                    }
                    IconPainter.curr.setRGB(n4, n5, Palette.currcolor);
                    Grid.handle.repaint();
                    break;
                }
            }
        } else if (tracking && (n3 == 31 || n3 == 30 || n3 == 34)) {
            this.drawSegment(n, n2);
        }
    }

    static void reset() {
        cols = IconPainter.cols;
        rows = IconPainter.rows;
        sqdim = IconPainter.sqdim;
        wminus1 = wid - 1;
        hminus1 = hgt - 1;
        lines = IPUtils.darken(IconPainter.backcol);
        wid = cols * sqdim;
        hgt = rows * sqdim;
        curr = IconPainter.curr;
    }

    static void setClip(Graphics2D graphics2D) {
        if (clip) {
            graphics2D.setClip(clipx, clipy, clipxoff, clipyoff);
        }
    }

    static void setStatus(int n) {
        Status.action = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    static void updateBoxes() {
        int n = 0;
        while (n < idx) {
            Rectangle rectangle = boxes[n];
            Point point = controls[n];
            rectangle.x = point.x - 10;
            rectangle.y = point.y - 10;
            ++n;
        }
    }
}

