/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.HexColor;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.InfoBar;
import com.equitysoft.icon.Palette;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.XPMChooser;
import com.equitysoft.icon.XPMList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JColorChooser;
import javax.swing.JMenu;

class ColorMenu
extends JMenu
implements ActionListener {
    static String SETCOLOR = "Customize current paint color";
    String GRABCOLOR = "Choose current color from current image";
    String REPLACE = "Replace a palette color with current";
    String SWAP = "Swap current and second color";
    String TEXTURE = "Use texture instead of color";
    String XPM_COLOR = "Choose from XPM colors";
    String XPM_NAME = "Choose XPM color by name";
    String HEX = "Specify color as Hex value";

    ColorMenu() {
        super("  Current  ");
        this.setMnemonic(67);
        this.add(IPUtils.getMI(SETCOLOR, this, 90));
        this.add(IPUtils.getMI(this.GRABCOLOR, this, 73));
        this.add(IPUtils.getMI(this.REPLACE, this, 82));
        this.add(IPUtils.getMI(this.SWAP, this, 83));
        this.addSeparator();
        this.add(IPUtils.getMI(this.TEXTURE, this, 84));
        this.addSeparator();
        this.add(IPUtils.getMI(this.XPM_COLOR, this, 88));
        this.add(IPUtils.getMI(this.XPM_NAME, this, 78));
        this.addSeparator();
        this.add(IPUtils.getMI(this.HEX, this, 72));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Status.clear();
        String string = actionEvent.getActionCommand();
        if (string == SETCOLOR) {
            Bar.handle.repaint();
            ColorMenu.setCurrent();
        } else if (string == this.GRABCOLOR) {
            Status.set("Click on pixel with new color", 4);
        } else if (string == this.REPLACE) {
            Status.set("Click on the palette color to replace", 1);
        } else if (string == this.SWAP) {
            InfoBar.swap();
        } else if (string == this.TEXTURE) {
            File file = FileManager.getChooserFile("Choose the image file to open");
            Image image = FileUtils.getImage(file, true, IconPainter.backcol);
            if (image == null) {
                return;
            }
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            image.flush();
            Palette.setTexture(bufferedImage);
        } else if (string == this.XPM_COLOR) {
            new XPMChooser();
        } else if (string == this.XPM_NAME) {
            new XPMList();
        } else if (string == this.HEX) {
            new HexColor();
        }
    }

    static void setCurrent() {
        Color color = JColorChooser.showDialog(Bar.handle, SETCOLOR, new Color(Palette.currcolor));
        if (color != null) {
            Palette.setCurrent(color.getRGB());
        }
    }
}

