/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.ArrowPanel;
import com.equitysoft.icon.DisplayMenu;
import com.equitysoft.icon.FileManager;
import com.equitysoft.icon.FileUtils;
import com.equitysoft.icon.FontBox;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.MBar;
import com.equitysoft.icon.OptionCombo;
import com.equitysoft.icon.OptionsBox;
import com.equitysoft.icon.Palette;
import com.equitysoft.icon.RecentFiles;
import com.equitysoft.icon.ShadeBar;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.ToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Bar
extends JFrame
implements KeyListener {
    static String EMPTY = "";
    static String text;
    static Bar handle;
    static JPanel outer;
    static ToolBar tb;
    static String TEXT_MSG;
    static String PRODUCT;

    static {
        TEXT_MSG = "Type a line of text, use backspace to delete characters";
        PRODUCT = "IconPainter 2.2";
    }

    Bar() {
        ((Component)this).setBackground(Color.lightGray);
        handle = this;
        ((Frame)this).setIconImage(IPUtils.getSystemImage(IconPainter.SYS_ICON));
        this.addKeyListener(this);
        this.setJMenuBar(new MBar());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        outer = new JPanel();
        Container container2 = new Container();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 1;
        ArrowPanel arrowPanel = new ArrowPanel();
        gridBagConstraints.anchor = 11;
        container2.add(arrowPanel);
        gridBagLayout.setConstraints(arrowPanel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        tb = new ToolBar();
        container2.add(tb);
        gridBagLayout.setConstraints(tb, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 15;
        OptionCombo optionCombo = new OptionCombo();
        container2.add(optionCombo);
        gridBagLayout.setConstraints(optionCombo, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 10;
        Palette palette = Palette.handle;
        container2.add(palette);
        gridBagLayout.setConstraints(palette, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(2, 1, 0, 1);
        ShadeBar shadeBar = new ShadeBar();
        container2.add(shadeBar);
        gridBagLayout.setConstraints(shadeBar, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridheight = 1;
        Status status = new Status();
        container2.add(status);
        gridBagLayout.setConstraints(status, gridBagConstraints);
        outer.add((Component)container2, "North");
        container.add((Component)outer, "Center");
        this.addWindowListener(IconPainter.closer);
        this.pack();
    }

    static void drawText() {
        if (Status.action != 12) {
            return;
        }
        IconPainter.clearTransImg();
        Graphics2D graphics2D = IPLib.getContext();
        Font font = OptionsBox.getCurrentFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = handle.getFontMetrics(font);
        int n = fontMetrics.stringWidth(text);
        int n2 = (IconPainter.rows - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
        if (n2 > IconPainter.rows) {
            n2 = IconPainter.rows;
        }
        int n3 = (IconPainter.cols - n) / 2;
        if (OptionsBox.filldirec != 0) {
            if (DisplayMenu.fillhow.getState() != 0) {
                IPLib.fillrec = new Rectangle(n3, n2 - fontMetrics.getAscent(), n, fontMetrics.getHeight());
            }
            graphics2D.drawString(text, n3, n2);
            IPLib.setGradientPaint(graphics2D, true);
            Bar.drawTextShadow(graphics2D, n3, n2);
            graphics2D.drawString(text, n3, n2);
        } else {
            Bar.drawTextShadow(graphics2D, n3, n2);
            graphics2D.drawString(text, n3, n2);
        }
        IPLib.paintTransImg();
    }

    static void drawTextShadow(Graphics2D graphics2D, int n, int n2) {
        if (OptionsBox.shadow == 0) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        graphics2D.setColor(IPLib.getShadow());
        graphics2D.drawString(text, OptionsBox.transx(n), OptionsBox.transy(n2));
        IPLib.blur(0);
        graphics2D.setPaint(paint);
    }

    static void initTextAdd() {
        FontBox.setUp();
        IconPainter.startAdd();
        Status.set(TEXT_MSG, 12);
        text = EMPTY;
        handle.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (Status.action != 12) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == '\r') {
            return;
        }
        if (c == '\b') {
            int n = text.length() - 1;
            text = n > 0 ? text.substring(0, n) : EMPTY;
        } else {
            if (text == null) {
                text = EMPTY;
            }
            text = String.valueOf(text) + c;
        }
        Bar.drawText();
    }

    static void setFile(File file) {
        if (FileUtils.type == 12) {
            return;
        }
        FileManager.currfile = file;
        RecentFiles.addFile(file);
        if (FileManager.a675) {
            handle.setTitle(" " + file.getName() + " - " + PRODUCT);
        } else {
            handle.setTitle(" " + file.getName() + " - " + PRODUCT + "  (Evaluation software)");
        }
    }

    static void setUntitled() {
        FileManager.currfile = null;
        if (FileManager.a675) {
            handle.setTitle(" Untitled - " + PRODUCT);
        } else {
            handle.setTitle(" Untitled - " + PRODUCT + "  (Evaluation software)");
        }
    }
}

