/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Bar;
import com.equitysoft.icon.CrissCross;
import com.equitysoft.icon.Grid;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.Status;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JMenu;

class BackMenu
extends JMenu
implements ActionListener {
    String BACK = "Customize background color";
    String CLICK = "Choose background color from curent image";
    String BACK_PALETTE = "Choose background from palette";

    BackMenu() {
        super("  Background  ");
        this.setMnemonic(66);
        this.add(IPUtils.getMI(this.BACK_PALETTE, this, 80));
        this.add(IPUtils.getMI(this.BACK, this, 90));
        this.add(IPUtils.getMI(this.CLICK, this, 73));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Status.clear();
        String string = actionEvent.getActionCommand();
        if (string == this.CLICK) {
            Status.set("Click on the image color to be the background color", 19);
        } else if (string == this.BACK) {
            Bar.handle.repaint();
            Color color = JColorChooser.showDialog(Bar.handle, this.BACK, IconPainter.backcol);
            if (color == null) {
                return;
            }
            IconPainter.resetBack(color);
            CrissCross.reset();
            Grid.handle.repaint();
        } else if (string == this.BACK_PALETTE) {
            Status.set("Click on the palette color to be the background", 13);
        }
    }
}

