/*
 * Decompiled with CFR 0.152.
 */
package com.equitysoft.icon;

import com.equitysoft.icon.Dummy;
import com.equitysoft.icon.IPLib;
import com.equitysoft.icon.IPUtils;
import com.equitysoft.icon.IPZap;
import com.equitysoft.icon.IconPainter;
import com.equitysoft.icon.PopupOptions;
import com.equitysoft.icon.SizeMenu;
import com.equitysoft.icon.SquareMenu;
import com.equitysoft.icon.Status;
import com.equitysoft.icon.SwingToolButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class ArrowPanel
extends JPanel
implements ActionListener {
    static Dimension DIM = new Dimension(25, 25);
    static SwingToolButton up;
    static SwingToolButton right;
    static SwingToolButton down;
    static SwingToolButton left;
    static SwingToolButton quarter;
    static SwingToolButton segment;
    static SwingToolButton cross;
    static SwingToolButton resize;
    static SwingToolButton grid;
    static SwingToolButton whole;
    static SwingToolButton erase;
    static ArrowPanel handle;
    static final Color BCOL;

    static {
        BCOL = new Color(204, 255, 204);
    }

    ArrowPanel() {
        handle = this;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridLayout(4, 3));
        this.add(new Dummy(DIM, true));
        up = this.getButton("up.gif", "Shift up");
        this.add(up);
        up.setRepeat(true);
        quarter = this.getButton("quarter.gif", "Rotate by 45 degrees");
        this.add(quarter);
        left = this.getButton("left.gif", "Shift left");
        this.add(left);
        left.setRepeat(true);
        cross = this.getButton("cross.gif", "Undo shift & rotate");
        this.add(cross);
        right = this.getButton("right.gif", "Shift right");
        this.add(right);
        right.setRepeat(true);
        segment = this.getButton("segment.gif", "Rotate by 15 degrees");
        this.add(segment);
        down = this.getButton("down.gif", "Shift down");
        this.add(down);
        down.setRepeat(true);
        whole = this.getButton("whole.gif", "Shift entire image");
        this.add(whole);
        erase = this.getButton("erase.gif", "Erase entire image");
        this.add(erase);
        grid = this.getButton("grid.gif", "Set grid square size");
        this.add(grid);
        resize = this.getButton("resize.gif", "Resize the image");
        this.add(resize);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (IconPainter.transimg == null) {
            new IPZap("There is nothing to be moved");
        }
        PopupOptions.hideIt();
        SwingToolButton swingToolButton = (SwingToolButton)actionEvent.getSource();
        if (swingToolButton == left) {
            --IPLib.xshift;
        } else if (swingToolButton == right) {
            ++IPLib.xshift;
        } else if (swingToolButton == up) {
            --IPLib.yshift;
        } else if (swingToolButton == down) {
            ++IPLib.yshift;
        } else if (swingToolButton == quarter) {
            IPLib.rotation += 0.7853981633974483;
        } else if (swingToolButton == segment) {
            IPLib.rotation += 0.2617993877991494;
        } else if (swingToolButton == cross) {
            IPLib.xshift = 0;
            IPLib.yshift = 0;
            IPLib.rotation = 0.0;
        }
        if (swingToolButton == erase) {
            IconPainter.createUndoBuffer();
            IconPainter.undone = true;
            IPUtils.copy(IconPainter.curr, IconPainter.undo);
            IPUtils.clearAll();
            IconPainter.refreshAll();
            Status.clear();
        } else if (swingToolButton == whole) {
            IconPainter.createUndoBuffer();
            IconPainter.startAdd();
            IPUtils.copy(IconPainter.orig, IconPainter.transimg);
            IPUtils.copy(IconPainter.orig, IconPainter.undo);
            IconPainter.undone = true;
            Graphics2D graphics2D = IconPainter.curr.createGraphics();
            graphics2D.setColor(IconPainter.backcol);
            graphics2D.fillRect(0, 0, IconPainter.cols, IconPainter.rows);
            graphics2D = IconPainter.orig.createGraphics();
            graphics2D.setColor(IconPainter.backcol);
            graphics2D.fillRect(0, 0, IconPainter.cols, IconPainter.rows);
        } else {
            if (swingToolButton == resize) {
                if (SizeMenu.handle.isVisible()) {
                    SizeMenu.handle.setVisible(false);
                    this.remove(SizeMenu.handle);
                    return;
                }
                this.add(SizeMenu.handle);
                SizeMenu.handle.show(this, swingToolButton.getLocation().x, swingToolButton.getLocation().y + swingToolButton.getSize().height);
                return;
            }
            if (swingToolButton == grid) {
                if (SquareMenu.handle.isVisible()) {
                    SquareMenu.handle.setVisible(false);
                    this.remove(SquareMenu.handle);
                    return;
                }
                this.add(SquareMenu.handle);
                SquareMenu.handle.show(this, swingToolButton.getLocation().x, swingToolButton.getLocation().y + swingToolButton.getSize().height);
                return;
            }
        }
        IPLib.paintTransImg();
    }

    SwingToolButton getButton(String string, String string2) {
        Image image = IPUtils.getSystemImage(string);
        SwingToolButton swingToolButton = new SwingToolButton(image, string2, DIM, this, null);
        return swingToolButton;
    }
}

