/*
 * com.e4graph.Storage:
 *
 *	This file contains the Java implementation of a class to wrap
 *	around e4Graph storage objects.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.e4graph;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class StorageIterator implements Iterator {
    /*
     * State variables:
     */
    private int index = -1;
    private Storage current = null;
    private Storage next = null;

    /**
     * Constructor that returns an iterator that will iterate over all
     * open storages in turn.
     */
    public StorageIterator() {}

    /**
     * Is there another storage to iterate over?
     */
    public boolean hasNext() {
	if (next == null) {
	    next = computeNext(index);
	}
	if (next != null) {
	    index = next.getIndex();
	    return true;
	}
	return false;
    }

    /**
     * Get the next storage to visit.
     */
    public Object next()
	throws NoSuchElementException
    {
	Storage s;

	if (!hasNext()) {
	    throw new
		NoSuchElementException("no more storages to iterate over");
	}
	s = next;
	next = null;
	return s;
    }

    /**
     * The remove() operation always throws UnsupportedOperationException.
     */
    public void remove()
	throws UnsupportedOperationException
    {
	throw new UnsupportedOperationException("remove() is not supported");
    }

    /*
     * This native operation creates and returns a com.e4graph.Storage object
     * representing the e4_Storage cached at the first valid index after the
     * given index.
     */
    private native Storage computeNext(int index);
}
