# convert.tcl --
#
# Convert all relevant files to a specified end-of-line format (default
# is crlf).
#
# Copyright (c) 2000-2003, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN
# IF JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.

# This is the list of patterns for file names that we want to convert:

set filesToConvert {*.h *.cpp *.c *.html *.tcl *.txt *.opt *.m4 *.sh *.csh
		    makefile* *.in config.* license ltconfig License Tags
		    *.java package-list changes Install readme *.xml *.r *.css
		    *.py configure *.dsw *.dsp *.sln *.vcproj}

# Convert a single file:

proc convertfile {fn {cvmode crlf}} {
    set fdi [open $fn r]
    set fdo [open ${fn}.copied w]

    fconfigure $fdi -translation auto
    fconfigure $fdo -translation $cvmode

    fcopy $fdi $fdo

    close $fdi
    close $fdo

    file rename -force ${fn}.copied $fn
}

# Convert a directory and all its sub-directories:

proc convertdir {dirname {cvmode crlf}} {
    global filesToConvert

    # First convert in all sub-directories:

    foreach d [glob -nocomplain -types d [file join $dirname *]] {
	convertdir $d $cvmode
    }

    # Now convert all files of interest here:

    set filelist ""
    foreach p $filesToConvert {
	lappend filelist [file join $dirname $p]
    }

    foreach f [eval glob -nocomplain -types f $filelist] {
	convertfile $f $cvmode
    }
}
