package soda.test.collections;

import java.util.*;

import com.db4o.query.*;
import soda.test.*;

public class STTreeSetU implements STClass {

	public static transient SodaTest st;
	
	Object col;

	public STTreeSetU() {
	}

	public STTreeSetU(Object[] arr) {
		col = new TreeSet();
		for (int i = 0; i < arr.length; i++) {
			((TreeSet)col).add(arr[i]);
		}
	}

	public Object[] store() {
		return new Object[] {
			new STTreeSetU(),
			new STTreeSetU(new Object[0]),
			new STTreeSetU(new Object[] { new Integer(0), new Integer(0)}),
			new STTreeSetU(
				new Object[] {
					new Integer(1),
					new Integer(17),
					new Integer(Integer.MAX_VALUE - 1)}),
			new STTreeSetU(
				new Object[] {
					new Integer(3),
					new Integer(17),
					new Integer(25),
					new Integer(Integer.MAX_VALUE - 2)})
		};
	}

	public void testDefaultContainsInteger() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(new STTreeSetU(new Object[] { new Integer(17)}));
		st.expect(q, new Object[] { r[3], r[4] });
	}

	public void testDefaultContainsTwo() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(new STTreeSetU(new Object[] { new Integer(17), new Integer(25)}));
		st.expect(q, new Object[] { r[4] });
	}

	public void testDescendOne() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(STTreeSetU.class);
		q.descend("col").constrain(new Integer(17));
		st.expect(q, new Object[] { r[3], r[4] });
	}

	public void testDescendTwo() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(STTreeSetU.class);
		Query qElements = q.descend("col");
		qElements.constrain(new Integer(17));
		qElements.constrain(new Integer(25));
		st.expect(q, new Object[] { r[4] });
	}

	public void testDescendSmaller() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(STTreeSetU.class);
		Query qElements = q.descend("col");
		qElements.constrain(new Integer(3)).smaller();
		st.expect(q, new Object[] { r[2], r[3] });
	}
	

}