package soda.test.collections;

import java.util.*;

import com.db4o.query.*;
import soda.test.*;

public class STHashtableED implements STClass {
	
	public static transient SodaTest st;
	
	public static class ExtendHashtable extends Hashtable{
	}
	
	protected ExtendHashtable vec(Object[] objects){
		ExtendHashtable h = new ExtendHashtable();
		for (int i = 0; i < objects.length; i++) {
			h.put(objects[i], new Integer(i));
		}
		return h;
	}

	public Object[] store() {
		return new Object[] {
			vec(new Object[] { new Integer(6778), new Integer(6779)}), 
			vec(new Object[] { new Integer(6778), new Integer(6789)}),
			vec(new Object[] { "foo677", new STElement("bar677", "barbar677")}),
			vec(new Object[] { "foo6772", new STElement("bar677", "barbar2677")})
		};
	}
	
	public void testDefaultContainsInteger() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(vec(new Object[] { new Integer(6778)}));
		st.expect(q, new Object[] { r[0], r[1] });
	}

	public void testDefaultContainsString() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(vec(new Object[] { "foo677" }));
		st.expect(q, new Object[] { r[2] });
	}

	public void testDefaultContainsTwo() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(vec(new Object[] { new Integer(6778), new Integer(6789)}));
		st.expect(q, new Object[] { r[1] });
	}

	public void testDefaultContainsObject() {
		Query q = st.query();
		Object[] r = store();
		q.constrain(vec(new Object[] { new STElement("bar677", null)}));
		st.expect(q, new Object[] { r[2], r[3] });
	}
	
}