package soda.test;

import com.db4o.*;
import com.db4o.query.*;
import soda.test.classes.simple.*;
import soda.test.classes.wrapper.untyped.*;
import soda.test.collections.*;
import soda.test.engines.db4o.*;

public class SodaTestThreadedRegression extends SodaTest implements Runnable{
	
	private static final Object lock = new Object();
	private static int RUNS = 300;
	
	private final STClass[] classes;
	private static volatile int runningThreads;
	
	
	public SodaTestThreadedRegression(STClass[] classes){
		this.classes = classes;
		setSodaTestOn(classes);
	}
	
	public static void main(String[] args) {
		
		cascadeOnDelete(new STArrayListT());
		cascadeOnDelete(new STOwnCollectionW());
		
		time = System.currentTimeMillis();
		
		engine = new STDb4o();
		//engine = new STDb4oClientServer();
		
		engine.reset();
		engine.open();
		
		startThread(new STClass[] {new STString()});
		startThread(new STClass[] {new STInteger()});
		startThread(new STClass[] {new STByte()});
		startThread(new STClass[] {new STShort()});
		startThread(new STClass[] {new STBooleanWU()});
		startThread(new STClass[] {new STOwnCollectionW()});
		startThread(new STClass[] {new STArrayListT()});
		
		// We don't want to run out of main to allow sequential
		// execution of Ant tasks.
		do{
			try{
				Thread.currentThread().sleep(300);
			}catch(Exception e){
			}
		}while(runningThreads > 0);
	}
	
	private static void startThread(STClass[] classes){
		for (int i = 0; i < classes.length; i++) {
			if(! jdkOK(classes[i])){
				System.out.println("Test case can't run on this JDK: " + classes[i].getClass().getName());
				return;
			}
		}
		new Thread(new SodaTestThreadedRegression(classes)).start();
	}
	
	protected String name(){
		return "S.O.D.A. threaded test";
	}
	
	public void run(){
		String name;
		synchronized(lock){
			runningThreads ++;
			name = "R " + runningThreads + " ";
		}
		Thread.currentThread().setName(name);
		
		for (int i = 0; i < RUNS; i++) {
			if(! QUIET){
				System.out.println(name + i);
			}
			store(classes);
			engine.commit();
			test(classes);
			for (int j = 0; j < classes.length; j++) {
				Query q = engine.query();
				q.constrain(classes[j].getClass());
				ObjectSet os = q.execute();
				while(os.hasNext()){
					engine.delete(os.next());
				}
			}
		}
		
		synchronized(lock){
			runningThreads --;
			if(runningThreads < 1){
				engine.close();
				completed();
			}
		}
	}
	
	public static void cascadeOnDelete(Object obj){
		Db4o.configure().objectClass(obj.getClass().getName()).cascadeOnDelete(true);
	}
	
}

