package soda.test;

import java.lang.reflect.*;

import com.db4o.*;
import com.db4o.lib.*;
import com.db4o.query.*;

import soda.test.arrays.object.*;
import soda.test.arrays.typed.*;
import soda.test.arrays.untyped.*;
import soda.test.classes.simple.*;
import soda.test.classes.typedhierarchy.*;
import soda.test.classes.untypedhierarchy.*;
import soda.test.classes.wrapper.typed.*;
import soda.test.classes.wrapper.untyped.*;
import soda.test.collections.*;
import soda.test.engines.db4o.*;
import soda.test.joins.typed.*;
import soda.test.joins.untyped.*;
import soda.test.ordered.*;
import soda.test.utils.*;

public class SodaTest {

    protected static final boolean QUIET = false;

    private static final STEngine[] ENGINES = new STEngine[] { 
    	new STDb4o()
        // new STDb4oClientServer()
    };

    private static final STClass[] CLASSES =
        new STClass[] {
            new STArrayListT(),
            new STArrayListU(),
            new STArrMixed(),
            new STArrStringO(),
            new STArrStringON(),
            new STArrStringT(),
            new STArrStringTN(),
            new STArrStringU(),
            new STArrStringUN(),
            new STArrIntegerO(),
            new STArrIntegerON(),
            new STArrIntegerT(),
            new STArrIntegerTN(),
            new STArrIntegerU(),
            new STArrIntegerUN(),
            new STArrIntegerWT(),
            new STArrIntegerWTON(),
            new STArrIntegerWUON(),
            new STBoolean(),
            new STBooleanWT(),
            new STBooleanWU(),
            new STByte(),
            new STByteWT(),
            new STByteWU(),
            new STChar(),
            new STCharWT(),
            new STCharWU(),
            new STDate(),
            new STDateU(),
            new STDouble(),
            new STDoubleWT(),
            new STDoubleWU(),
            new STETH1(),
            new STFloat(),
            new STFloatWT(),
            new STFloatWU(),
            new STHashSetT(),
            new STHashSetU(),
            new STHashtableD(),
            new STHashtableED(),
            new STHashtableET(),
            new STHashtableEU(),
            new STHashtableT(),
            new STHashtableU(),
            new STInteger(),
            new STIntegerWT(),
            new STIntegerWU(),
            new STLinkedListT(),
            new STLinkedListU(),
            new STLong(),
            new STLongWT(),
            new STLongWU(),
            new STOrT(),
            new STOrU(),
            new STOString(),
            new STOInteger(),
            new STOIntegerWT(),
            new STOwnCollectionT(),
            new STOwnCollectionW(),
            new STRTH1(),
            new STSDFT1(),
            new STShort(),
            new STShortWT(),
            new STShortWU(),
            new STString(),
            new STStringU(),
            new STRUH1(),
            new STTH1(),
            new STTreeSetT(),
            new STTreeSetU(),
            new STUH1(),
            new STVectorD(),
            new STVectorED(),
            new STVectorT(),
            new STVectorU(),
            new STVectorET(),
            new STVectorEU(),

        // recommend to take a look !!!
        new STMagic(), };

    protected static STEngine engine;
    private static int testCases;
    private STClass currentTestClass;
    private List4 failedTestClasses;
    private final STCompare comparer = new STCompare();
    static long time;

    public static void main(String[] args) {
        time = System.currentTimeMillis();
        SodaTest st = new SodaTest();
        st.run(CLASSES);
        st.completed();
    }

    protected void completed() {
        time = System.currentTimeMillis() - time;
        System.out.println(name() + " completed. " + time + " ms");
        System.out.println("Test cases: " + testCases);
    }

    protected String name() {
        return "S.O.D.A. functionality test";
    }

    public void run(STClass[] classes) {

        failedTestClasses = new List4();

        setSodaTestOn(classes);

        for (int i = 0; i < ENGINES.length; i++) {
            engine = ENGINES[i];
            engine.reset();
            engine.open();
            store(classes);
            engine.commit();
            engine.close();
            engine.open();
            test(classes);
            engine.close();
            engine.reset();
        }

        if (failedTestClasses.size() > 0) {
            System.err.println("\nFailed test classes:\n");
            Iterator4 i = failedTestClasses.iterator();
            while (i.hasNext()) {
                System.err.println(i.next().getClass().getName());
            }
            System.err.println("\n");
        }
    }

    protected void store(STClass[] classes) {
        for (int i = 0; i < classes.length; i++) {
            if (jdkOK(classes[i])) {
                Object[] objects = classes[i].store();
                if (objects != null) {
                    for (int j = 0; j < objects.length; j++) {
                        engine.store(objects[j]);
                    }
                }
            }
        }
    }

    /** dynamic execution of all public methods that begin with "test" in all CLASSES */
    protected void test(STClass[] classes) {
        for (int i = 0; i < classes.length; i++) {
            if (jdkOK(classes[i])) {
                currentTestClass = classes[i];
                Method[] methods = classes[i].getClass().getDeclaredMethods();
                for (int j = 0; j < methods.length; j++) {
                    Method method = methods[j];
                    if (method.getName().startsWith("test")) {
                        try {
                            method.invoke(classes[i], null);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    protected static boolean jdkOK(Object obj) {
        return com.db4o.lib.Platform.isJDK2() || STClass1.class.isAssignableFrom(obj.getClass());
    }

    public Query query() {
        return engine.query();
    }

    public void expectOne(Query query, Object object) {
        expect(query, new Object[] { object });
    }

    public void expectNone(Query query) {
        expect(query, null);
    }

    public void expect(Query query, Object[] results) {
        expect(query, results, false);
    }

    public void expectOrdered(Query query, Object[] results) {
        expect(query, results, true);
    }

    private void expect(Query query, Object[] results, boolean ordered) {
        testCases++;
        ObjectSet set = query.execute();
        if (results == null || results.length == 0) {
            if (set.size() > 0) {
                error("No content expected.");
            }
            return;
        }
        int j = 0;
        if (set.size() == results.length) {
            while (set.hasNext()) {
                Object obj = set.next();
                boolean found = false;
                if (ordered) {
                    if (comparer.isEqual(results[j], obj)) {
                        results[j] = null;
                        found = true;
                    }
                    j++;
                } else {
                    for (int i = 0; i < results.length; i++) {
                        if (results[i] != null) {
                            if (comparer.isEqual(results[i], obj)) {
                                results[i] = null;
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    error("Object not expected: " + obj);
                }
            }
            for (int i = 0; i < results.length; i++) {
                if (results[i] != null) {
                    error("Expected object not returned: " + results[i]);
                }
            }
        } else {
            error(
                "Unexpected size returned.\nExpected: "
                    + results.length
                    + " Returned: "
                    + set.size());
        }
    }

    public void error(String msg) {
        if (!failedTestClasses.contains(currentTestClass)) {
            failedTestClasses.add(currentTestClass);
        }
        if (!QUIET) {
            System.err.println(msg);
            new ExpectationFailed().printStackTrace();
            System.err.println();
        }
    }

    public static void log(Query query) {
        ObjectSet set = query.execute();
        while (set.hasNext()) {
            STLogger.log(set.next());
        }
    }
    
    protected void setSodaTestOn(STClass[] classes) {
        for (int i = 0; i < classes.length; i++) {
            try {
                Field field = classes[i].getClass().getDeclaredField("st");
                try {
                    com.db4o.lib.Platform.setAccessible(field);
                } catch (Throwable t) {
                    // JDK 1.x has no setAccessible
                }
                field.set(classes[i], this);
            } catch (Exception e) {
                System.err.println(
                    "Add the following line to Class " + classes[i].getClass().getName());
                System.err.println("public static transient SodaTest st;");
            }
        }
    }

}

class ExpectationFailed extends Exception {
    ExpectationFailed() {
    }
}
