package com.db4o.test;

import com.db4o.*;

public class TwoClients implements TestConfiguration{
	
	public void store(){
		Test.deleteAllInstances(new Atom());
	}
	
	public void test(){
		if(Test.clientServer){
			ObjectContainer client2 = null;
			try {
                client2 =
                    Db4o.openClient(SERVER_HOSTNAME, SERVER_PORT, DB4O_USER, DB4O_PASSWORD);
            } catch (Exception e) {
                e.printStackTrace();
                return ;
            }
            ObjectContainer client1 = Test.objectContainer();
            Atom a_1_1 = new Atom("One");
            client1.set(a_1_1);
            ensureAtomCount(client2, 0);
            client1.commit();
            ensureAtomCount(client2, 1);
            Atom a_2_1 = (Atom)client2.get(new Atom("One")).next();
            a_1_1.child = new Atom("OneChild");
            client1.set(a_1_1);
            ensureAtomCount(client2, 1);
            client1.commit();
            ensureAtomCount(client2, 2);
            client2.deactivate(a_2_1, Integer.MAX_VALUE);
            client2.activate(a_2_1, Integer.MAX_VALUE);
            Test.ensure(a_2_1.child.name.equals("OneChild"));
            client2.close();
		}
	}
	
	private void ensureAtomCount(ObjectContainer con, int count){
		
		// try five times
		// commit timing might cause delay to see result
		for (int i = 0; i < 5; i++) {
			if(con.get(new Atom()).size() == count){
				return;
			}
        }
        Test.error();
	}
	
	
	
	
	
}
