package com.db4o.test;

import java.util.*;
import com.db4o.*;

public class TestHashTable {
	
	Hashtable ht;
	
	public void configure(){
		Db4o.configure().objectClass(getClass().getName()).cascadeOnUpdate(true);
		Db4o.configure().objectClass(getClass().getName()).cascadeOnDelete(true);
	}
	
	public void store(){
		Test.deleteAllInstances(this);
		Test.deleteAllInstances(new Atom());
		Test.deleteAllInstances(new com.db4o.config.Entry());
		TestHashTable tht = new TestHashTable();
		tht.ht = new Hashtable();
		tht.ht.put("t1", new Atom("t1"));
		tht.ht.put("t2", new Atom("t2"));
		Test.store(tht);
	}
	
	public void test(){
		com.db4o.config.Entry checkEntries = new com.db4o.config.Entry();
		TestHashTable tht = (TestHashTable)Test.getOne(this);
		Test.ensure(tht.ht.size() == 2);
		Test.ensure(tht.ht.get("t1").equals(new Atom("t1")));
		Test.ensure(tht.ht.get("t2").equals(new Atom("t2")));
		tht.ht.put("t2", new Atom("t3"));
		Test.store(tht);
		Test.ensureOccurrences(checkEntries, 2);
		Test.commit();
		Test.ensureOccurrences(checkEntries, 2);
		Test.deleteAllInstances(this);
		Test.ensureOccurrences(checkEntries, 0);
		Test.rollBack();
		Test.ensureOccurrences(checkEntries, 2);
		Test.deleteAllInstances(this);
		Test.ensureOccurrences(checkEntries, 0);
		Test.commit();
		Test.ensureOccurrences(checkEntries, 0);
	}
}
