package com.db4o.test;

import java.io.*;

import com.db4o.*;
import com.db4o.lib.*;
import com.db4o.query.*;
import com.db4o.tools.*;

public class Test implements TestConfiguration {

    private static ObjectServer objectServer;
    private static ObjectContainer objectContainer;

    private static Object lock = new Object();
    static AllTests currentRunner;
    static boolean clientServer = true;
    static boolean runServer = true;

    public static void main(String[] args) {
        throw new RuntimeException("This class is not intended to be run. Run AllTests.java.");
    }

    public static boolean canCheckFileSize() {
        if (currentRunner != null) {
            return !clientServer || !currentRunner.REMOTE_SERVER;
        }
        return false;
    }

    public static void close() {
        while (!objectContainer.close());
        objectContainer = null;
    }

    public static void commit() {
        objectContainer.commit();
    }

    public static void delete() {
        new File(FILE_SOLO).delete();
        new File(FILE_SERVER).delete();
    }

    public static void delete(Object obj) {
        objectContainer().delete(obj);
    }

    public static void deleteAllInstances(Object obj) {
        try {
            Class clazz = obj.getClass();
            obj = clazz.newInstance();
            objectContainer.deactivate(obj, Integer.MAX_VALUE);
            ObjectSet set = objectContainer.get(obj);
            while (set.hasNext()) {
                objectContainer.delete(set.next());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void end() {
        if (objectContainer != null) {
            while (!objectContainer.close());
        }
        if (objectServer != null) {
            try {
                lock.wait(1000);
            } catch (Exception e) {
            }
            objectServer.close();
            objectServer = null;
        }
    }

    public static boolean ensure(boolean condition) {
        if (!condition) {
            error();
            return false;
        }
        return true;
    }

    public static void ensureOccurrences(Object obj, int count) {
        ensure(occurrences(obj) == count);
    }

    public static void error() {
        new Exception().printStackTrace();
    }

    public static int fileLength() {
        String fileName = clientServer ? FILE_SERVER : FILE_SOLO;
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "r");
            raf.getFD().sync();
            raf.close();
            return (int) new File(fileName).length();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void forEach(Object obj, Visitor4 vis) {
        ObjectContainer con = objectContainer();
        con.deactivate(obj, Integer.MAX_VALUE);
        ObjectSet set = objectContainer.get(obj);
        while (set.hasNext()) {
            vis.visit(set.next());
        }
    }

    public static Object getOne(Object obj) {
        ObjectContainer con = objectContainer();
        con.deactivate(obj, Integer.MAX_VALUE);
        ObjectSet set = con.get(obj);
        if (set.size() != 1) {
            error();
        }
        return set.next();
    }

    public static void logAll() {
        ObjectSet set = objectContainer.get(null);
        while (set.hasNext()) {
            Logger.log(objectContainer, set.next());
        }
    }

    public static ObjectContainer objectContainer() {
        if (objectContainer == null) {
            open();
        }
        return objectContainer;
    }

    public static int occurrences(Object obj) {
        try {
        	
        	// This test will currently not work in S.O.D.A. evaluataion
        	// mode for classes implementing com.db4o.config.Compare, like
        	// com.db4o.config.Entry.
        	// 
        	// The reason: a Compare object typically returns a member object
        	// to be used for a query.
        	 
            Class clazz = obj.getClass();
            obj = clazz.newInstance();
            objectContainer.deactivate(obj, Integer.MAX_VALUE);
            return objectContainer.get(obj).size();
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static ObjectContainer open() {
        if (runServer && clientServer && objectServer == null) {
            objectServer = Db4o.openServer(FILE_SERVER, SERVER_PORT);
            objectServer.grantAccess(DB4O_USER, DB4O_PASSWORD);
            objectServer.ext().configure().messageLevel(0);
        }
        if (clientServer) {
            try {
                objectContainer =
                    Db4o.openClient(SERVER_HOSTNAME, SERVER_PORT, DB4O_USER, DB4O_PASSWORD);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            objectContainer = Db4o.openFile(FILE_SOLO);
        }
        return objectContainer;
    }
    
    public static Query query(){
    	return objectContainer().query();
    }

    public static ObjectContainer reOpen() {
        close();
        try {
            lock.wait(100);
        } catch (Exception e) {
        }
        return open();
    }

    public static void rollBack() {
        objectContainer().rollback();
    }

    public static void store(Object obj) {
        objectContainer().set(obj);
    }

    public static void statistics() {
        Statistics.main(new String[] { FILE_SOLO });
    }

}
