package com.db4o.test;

import java.io.*;

import com.db4o.*;
import com.db4o.test.types.*;
import com.db4o.tools.*;

public class Cascades {
	
	String name;
	Cascades cascades;
	ObjectSimplePublic osp;
	Cascades[] arrCascades;
	ObjectSimplePublic[] arrOsp;
	
	static String FILE = "cascades.yap";
	
	public static void main(String[] args) {
		Db4o.configure().activationDepth(1);
		set();
		// Db4o.configure().objectClass("com.db4o.test.Cascades").cascadeOnActivate(true);
		// Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("cascades").cascadeOnActivate(true);
		// get();
		
		// Db4o.configure().objectClass("com.db4o.test.Cascades").cascadeOnDelete(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("cascades").cascadeOnDelete(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("arrCascades").cascadeOnDelete(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("osp").cascadeOnDelete(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("arrOsp").cascadeOnDelete(true);
		// delete();
		

		// Db4o.configure().objectClass("com.db4o.test.Cascades").cascadeOnUpdate(true);
		/*
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("cascades").cascadeOnUpdate(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("arrCascades").cascadeOnUpdate(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("osp").cascadeOnUpdate(true);
		Db4o.configure().objectClass("com.db4o.test.Cascades").objectField("arrOsp").cascadeOnUpdate(true);
		*/
 		updateComplex();
		
		
		
		getAll();
	}
	
	
	static void set(){
		new File(FILE).delete();
		ObjectContainer con = Db4o.openFile(FILE);
		Cascades cc = new Cascades();
		cc.name = "Level1";
		cc.cascades = new Cascades();
		cc.cascades.name = "Level2";
		cc.cascades.cascades = new Cascades();
		cc.cascades.cascades.name = "Level3";
		
		cc.osp = new ObjectSimplePublic();
		cc.osp.set(1);
		cc.cascades.osp = new ObjectSimplePublic();
		cc.cascades.osp.set(1);
		
		cc.arrOsp = new ObjectSimplePublic[] {new ObjectSimplePublic()};
		cc.arrOsp[0].set(1);
		cc.arrCascades = new Cascades[]{new Cascades()};
		cc.arrCascades[0].name = "Array Level2";
		cc.arrCascades[0].osp = new ObjectSimplePublic();
		cc.arrCascades[0].osp.set(1);
		cc.arrCascades[0].cascades = new Cascades();
		cc.arrCascades[0].cascades.name = "Array Level3";
		
		con.set(cc);
		con.close();
	}
	
	
	static void get(){
		ObjectContainer con = Db4o.openFile(FILE);
		Cascades cc = new Cascades();
		cc.cascades = new Cascades();
		cc.cascades.cascades = new Cascades();	
		ObjectSet set = con.get(cc);
		while(set.hasNext()){
			Logger.log(con, set.next());
		}
		con.close();
	}
	
	static void getAll(){
		ObjectContainer con = Db4o.openFile(FILE);
		Cascades cc = new Cascades();
		cc.cascades = new Cascades();
		cc.cascades.cascades = new Cascades();	
		ObjectSet set = con.get(null);
		while(set.hasNext()){
			Object obj = set.next();
			con.activate(obj, Integer.MAX_VALUE);
			Logger.log(con, obj);
		}
		con.close();
	}
	
	
	static void updateSimple(){
		ObjectContainer con = Db4o.openFile(FILE);
		Cascades cc = new Cascades();
		cc.cascades = new Cascades();
		cc.cascades.cascades = new Cascades();	
		ObjectSet set = con.get(cc);
		Cascades toUpdate = (Cascades)set.next();
		con.activate(toUpdate, Integer.MAX_VALUE);
		toUpdate.cascades.name = "Level2 Update";
		toUpdate.cascades.cascades.name = "Level3 Update";
		// toUpdate.osp.name = "OSP Update";
		con.set(toUpdate);
		con.close();
	}
	
	static void updateComplex(){
		ObjectContainer con = Db4o.openFile(FILE);
		Cascades cc = new Cascades();
		cc.cascades = new Cascades();
		cc.cascades.cascades = new Cascades();	
		ObjectSet set = con.get(cc);
		Cascades toUpdate = (Cascades)set.next();
		con.activate(toUpdate, Integer.MAX_VALUE);
		
		toUpdate.cascades = null;
		
		/*
		toUpdate.cascades = new Cascades();
		toUpdate.cascades.name = "Level2 New";
		*/
		
		/*
		toUpdate.arrCascades = null;
		toUpdate.osp = null;
		toUpdate.arrOsp = null;
		*/
		
		toUpdate.arrCascades = new Cascades[] {new Cascades()};
		toUpdate.arrCascades[0].name = "Level2 Arr New";
		con.set(toUpdate);
		con.close();
	}
	
	
	static void delete(){
		ObjectContainer con = Db4o.openFile(FILE);
		Cascades cc = new Cascades();
		cc.cascades = new Cascades();
		cc.cascades.cascades = new Cascades();	
		ObjectSet set = con.get(cc);
		Cascades toDelete = (Cascades)set.next();
		con.activate(toDelete, Integer.MAX_VALUE);
		con.delete(toDelete);
		con.close();
	}
	
}
