package com.db4o.test;

import com.db4o.*;
import com.db4o.test.types.*;

public class Callbacks extends RTest
{
	public CallbackHelper helper;
	public String name;
	
	public void run(){
	}
	
	public void objectOnActivate(ObjectContainer container){
		System.out.println("onActivate");
		container.activate(helper, 3);
	}
	
	public void objectOnDeactivate(ObjectContainer container){
		System.out.println("onDeactivate");
		container.deactivate(helper, 3);
	}
	
	public void objectOnDelete(ObjectContainer container){
		System.out.println("onDelete");
		container.delete(helper);
	}
	
	public void objectOnNew(ObjectContainer container){
		System.out.println("onNew");
		container.set(helper);
	}	
	
	public void objectOnUpdate(ObjectContainer container){
		System.out.println("onUpdate");
		container.set(helper);
	}

	public void set(int ver){
		if(ver == 1){
			name = "OneONEOneONEOneONEOneONEOneONEOneONE";	
			helper = new CallbackHelper();
			helper.parent = this;
			helper.name = "helper 1";
			
		}else{
			name = "TwoTWOTwoTWOTwoTWOTwoTWOTwoTWO";	
			helper = new CallbackHelper();
			helper.parent = this;
			helper.name = "helper 2";
		}
	}
	
	
}
