package com.db4o.test;

import com.db4o.*;

public class CallbackHelper {

		public String name;
		public Callbacks parent;
		
		public void objectOnActivate(ObjectContainer container){
			System.out.println("helper onActivate");
			container.activate(parent, 3);
		}
		
		public void objectOnDeactivate(ObjectContainer container){
			System.out.println("helper onDeactivate");
			container.deactivate(parent, 3);
		}
		
		public void objectOnDelete(ObjectContainer container){
			System.out.println("helper onDelete");
			container.delete(parent);
		}
		
		public void objectOnNew(ObjectContainer container){
			System.out.println("helper onNew");
			container.set(parent);
		}
		
		public void objectOnUpdate(ObjectContainer container){
			System.out.println("helper onUpdate");
			container.set(parent);
		}
}
