package com.db4o.test;

import java.lang.reflect.*;

import com.db4o.*;

/**
 * Tests will slowly be rewritten and migrated from
 * old Regression format.
 * 
 * Run Regression.java for the majority of the old tests.
 * 
 * Further Configuration Parameters can be found in
 * TestConfiguration.java. 
 */
public class AllTests implements Runnable, TestConfiguration{
	
	/** the number of test runs */
	final int RUNS = 1;
	
	/** run the tests stand-alone */
	final boolean SOLO = true;
	
	/** run the tests in client/server mode */
	final boolean CLIENT_SERVER = true;
	
	/** 
	 * run the client/server test against a remote server. 
	 * This requires AllTestsServer to be started on the
	 * other machine and TestConfiguration.SERVER_HOSTNAME
	 * to be set correctly.
	 */
	final boolean REMOTE_SERVER = false;
	

	final Class[] TESTS = new Class[] {
		CascadeOnDelete.class,
 		CascadeToArray.class,
		CascadeToExistingVectorMember.class,
		CascadeToHashMap.class,
		CascadeToHashtable.class,
		CascadeToVector.class,
		DiscreteArrayInMap.class,
		DualDelete.class,
		IsStored.class,
		KeepCollectionContent.class,
		PrimitiveArrayFileSize.class,
		SodaNoDuplicates.class,
		TestHashTable.class,
		TestHashMap.class,
		TestTreeMap.class,
		TwoClients.class,
		TypedArrayInObject.class,
		TypedDerivedArray.class
	};

	public static void main(String[] args){
		new AllTests().run();
	}
	
	public void run(){
		
		Db4o.configure().messageLevel(-1);

//		Db4o.configure().automaticShutDown(false);
//		Db4o.configure().lockDatabaseFile(false);

		logConfiguration();

		long time = System.currentTimeMillis();
		Test.delete();
		
		configure();
		
		for (int i = 1; i <= RUNS; i++) {
			System.out.println("com.db4o.AllTests run " + i + " from " + RUNS);
			if(SOLO){
				Test.runServer = false;
				Test.clientServer = false;
				runTests();
			}
			if(CLIENT_SERVER){
				Test.runServer = ! REMOTE_SERVER;
				Test.clientServer = true;
				runTests();
			}
			Test.end();
		}
		time = System.currentTimeMillis() - time;
		System.out.println("\n\nAllTests completed. Time: " + time + "ms");
		
	}
	
	protected void configure(){
		for (int i = 0; i < TESTS.length; i++) {
			Object toTest = newInstance(TESTS[i]);
			runMethod(toTest, "configure");
		}
	}

	private void runTests() {
		for (int i = 0; i < TESTS.length; i++) {
			Object toTest = newInstance(TESTS[i]);
			Test.open();
			runMethod(toTest, "store");
			Test.close();
			Test.open();
			Method[] methods = TESTS[i].getDeclaredMethods();
			for (int j = 0; j < methods.length; j++) {
				Method method = methods[j];
				if (method.getName().startsWith("test")) {
					try {
						method.invoke(toTest, null);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
			Test.close();
		}
	}
	
	private Object newInstance(Class clazz){
		try {
			return clazz.newInstance();
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		}
		System.out.println("Instantiation failed. Class:" + clazz.getName());
		return null;	
	}

	private void runMethod(Object onObject, String methodName) {
		try {
			Method method = onObject.getClass().getDeclaredMethod(methodName, null);
			if (method != null) {
				method.invoke(onObject, null);
			}
		} catch (Exception e) {
		}
	}
	
	protected void logConfiguration(){
		System.out.println("Starting " + getClass().getName() + ".\n\nSettings:");
		System.out.println(
			"TestConfiguration.SERVER_HOSTNAME: " + SERVER_HOSTNAME);
		System.out.println(
			"TestConfiguration.SERVER_PORT: " + SERVER_PORT );
		System.out.println("TestConfiguration.FILE_SERVER: " + FILE_SERVER);
		System.out.println("TestConfiguration.FILE_SOLO: " + FILE_SOLO + "\n\n");
	}
	
	public AllTests(){
		// no unneccessary visible methods in Test class.
		Test.currentRunner = this;
	}

}
