package com.db4o.sql;

import com.db4o.*;
import com.db4o.lib.*;
import com.db4o.jgen.*;
import java.lang.reflect.*;
import java.sql.*;

class SqlTable
{
	int fromIDColumn;
	int toIDColumn;

	private Class i_class;
	private String i_tableName;
	private List4 i_fields;

	public SqlTable(){
		i_fields = new List4();
	}

	void addFields(Class a_Class){
		if(Sql.hasPublicConstructor(a_Class)){
			Field[] fields = a_Class.getDeclaredFields();
			for (int i = 0 ; i < fields.length ; i ++){
				addField(SqlField.make(this,fields[i]));
			}
			addFields(a_Class.getSuperclass());
		}
	}

	public void addField(SqlField a_field){
		if (a_field != null){
			i_fields.add(a_field);
		}
	}

	public static SqlTable analyze(String a_className, boolean a_useFullName){
		Class l_Class = null;
		try{
			l_Class = Class.forName(a_className);
		}
		catch (Exception e){
			throw new RuntimeException("Class not found: " + a_className);
		}
		return analyze(l_Class, a_useFullName);
	}

	static SqlTable analyze(Class a_Class, boolean a_useFullName){
		SqlTable table = new SqlTable();
		table.i_class = a_Class;
		table.i_tableName = a_Class.getName();
		if(!a_useFullName){
			table.i_tableName = String4._splitRight(table.i_tableName, ".");
		}
		table.classNameToTableName();
		table.addFields(a_Class);
		return table;
	}

	void classNameToTableName(){
		i_tableName = String4._replace(i_tableName, ".", "_");
	}

	String classNameForTableName(){
		return String4._replace(i_tableName, "_", ".");
	}


	JClass createJavaFile(JPackage a_package){
		Sql.log("Making Java: " + getName());
		JClass l_Class = new JClass(getName(),a_package,"");
		l_Class.addImports("com.db4o");
		Iterator4 i = i_fields.iterator();
		while(i.hasNext()){
			l_Class.addField(((SqlField)i.next()).jfield());
		}
		l_Class.write();
		return l_Class;
	}

	public void createTable(Statement a_statement){
		createTable(a_statement,false);
	}

	void createTable(Statement a_statement, boolean addIDFields){
		SqlCreateTable create = new SqlCreateTable();
		create.setTable(i_tableName);
		Iterator4 i = i_fields.iterator();
		while(i.hasNext()){
			SqlField field = ((SqlField)i.next());
			create.addField(field.getName(),field.fieldCreate(a_statement));
		}
		if(addIDFields){
			create.addField(Sql.FROM_ID,Sql.INTEGER);
			create.addField(Sql.TO_ID,Sql.INTEGER);
		}
		createTable(a_statement, create);
	}

	static void createTable(Statement a_statement, SqlCreateTable a_create){
		try{
			Sql.log(a_create.statement());
			a_statement.execute(a_create.statement());
		}
		catch(Exception e){
			Sql.log("Creation of table failed: " + a_create.getName());
			Sql.log(e.getMessage());
		}
	}

	public void drop(Statement a_statement){
		try{
			a_statement.execute("drop table " + getName());
		}catch (Exception e){
		}
	}

	String[] getFields(){
		return null;
		// TODO: Whats this ????
	}

	public String getName(){
		return i_tableName;
	}


	void insert(ObjectContainer a_container, Object a_object, Statement a_statement){
		if(a_object != null){
			if(a_object.getClass().equals(i_class)){
				/* only objects of THIS class are added, so we don't get duplicates*/
				SqlInsert insert = new SqlInsert();
				insert.setTable(getName());
				Iterator4 i = i_fields.iterator();
				while(i.hasNext()){
					((SqlField)i.next()).insert(a_container, a_object, insert, a_statement);
				}
				insert.addField(Sql.FROM_ID,new Long(a_container.ext().getID(a_object)).toString());
				SqlTable.insert(a_statement, insert);
			}
		}
	}

	static void insert(Statement a_statement, SqlInsert a_insert){
		String sql = a_insert.statement();
		if (sql != null){
			try{
				a_statement.executeUpdate(sql);
			}
			catch(Exception e){
				Sql.log("Insert failed. Statement:");
				Sql.log(sql);
			}
		}
	}

	Iterator4 iterateFields(){
		return i_fields.iterator();
	}

	boolean mapToClass(){
		try{
			i_class = Class.forName(classNameForTableName());
			Object obt = i_class.newInstance(); // to make sure
			Sql.log("Class found: " + i_class.getName());
		}
		catch(Exception e){
			i_class = null;
			return false;
		}
		addFields(i_class);
		return true;
	}

	Object newObject(){
		try{
			return i_class.newInstance();
		}
		catch(Exception e){
			Sql.log("Instantiation failed:" + i_class.getName());
			return null;
		}
	}


	void reImportObjects(ObjectContainer a_db, Statement a_selectStatement, Statement a_updateStatement){
		Sql.log("Importing objects: " + getName() + " to " + i_class.getName());
		SqlSelect select = new SqlSelect();
		select.setTable(getName());
		SqlUpdate update = new SqlUpdate();
		update.setField(Sql.TO_ID);
		long fromID, toID;
		fromIDColumn = select.addField(Sql.FROM_ID);
		try{
			ResultSet rs = a_selectStatement.executeQuery(select.statement());
			while ( rs.next()){
				try{
					fromID = rs.getLong(fromIDColumn);
					Object object = i_class.newInstance();
					a_db.set(object);
					toID = a_db.ext().getID(object);
					update.setTable(getName());
					update.setValue(toID);
					update.setWhere(Sql.FROM_ID,fromID);
					a_updateStatement.executeUpdate(update.statement());
					update.setTable(Sql.MAP);
					if (! (a_updateStatement.executeUpdate(update.statement()) > 0) ){
						SqlInsert insert = new SqlInsert();
						insert.setTable(Sql.MAP);
						insert.addField(Sql.FROM_ID, fromID);
						insert.addField(Sql.TO_ID, toID);
						a_updateStatement.executeUpdate(insert.statement());
					}
				}
				catch(Exception e){
					Sql.error("Error during instantiation of " + i_class.getName());
					Sql.error(Sql.FROM_ID + " in " + getName() + ": " + rs.getString(fromIDColumn));
					Sql.error(e.getMessage());
				}
			}
		}catch(Exception e){
			Sql.error("Failed: " + select.statement());
			Sql.error(e.getMessage());
		}
	}

	void reWire(ObjectContainer a_db, Connection a_con, Statement a_statement){
		Sql.log("Wiring objects: " + i_class.getName());
		SqlField field;
		SqlSelect select = new SqlSelect();
		select.setTable(getName());
		SqlUpdate update = new SqlUpdate();
		update.setTable(getName());
		update.setField(Sql.TO_ID);
		long fromID,toID;

		Iterator4 iterateFields = i_fields.iterator();
		while(iterateFields.hasNext()){
			field = (SqlField)iterateFields.next();
			field.setColumn(select.addField(field.select()));
		}

		fromIDColumn = select.addField(Sql.FROM_ID);
		toIDColumn = select.addField(Sql.TO_ID);

		try{
			ResultSet rs = a_statement.executeQuery(select.statement());
			while ( rs.next()){
				try{
					toID = rs.getLong(toIDColumn);
					fromID = rs.getLong(fromIDColumn);
					Object object = a_db.ext().getByID(toID);
					iterateFields.reset();
					while(iterateFields.hasNext()){
						((SqlField)iterateFields.next()).instantiateOn(a_db, object, fromID, rs, a_con);
					}
					a_db.set(object);
				}
				catch(Exception e){
					Sql.error("Error during wiring of " + i_class.getName());
					Sql.error(Sql.FROM_ID + " : " + rs.getString(fromIDColumn));
					Sql.error(Sql.TO_ID + " : " + rs.getString(toIDColumn));
					Sql.error(e.getMessage());
				}
			}
		}catch(Exception e){
			Sql.error("Failed: " + select.statement());
			Sql.error(e.getMessage());
		}
	}




	String selectStatement(){
		// simple version for new import

		// might join the functionality with reImport at a later stage
		// possibly arrays could be detected earlier in
		// the normal SqlImport run

		SqlSelect select = new SqlSelect();
		select.setTable(getName());
		Iterator4 i = i_fields.iterator();
		while(i.hasNext()){
			SqlField field = (SqlField)i.next();
			field.setColumn(select.addField(field.getName()));
		}
		return select.statement();
	}

	public void setName(String a_name){
		i_tableName = a_name;
	}


}
