package com.db4o.sql;

import com.db4o.*;
import java.sql.*;

class SqlFieldObject extends SqlField
{
	private static Statement i_statement;
	private SqlSelect i_select;
	
	String fieldCreate(){
		return Sql.INTEGER;
	}
	
	Class getJavaClass(){
		return null;
	}
	
	Class getWrapperClass(){
		return null;
	}
	
	void insert1(ObjectContainer a_container, Object a_object, SqlInsert a_insert){
		a_insert.addField(i_name, new Long(a_container.ext().getID(a_object)).toString());
	}
	
	Object instantiate(ObjectContainer a_db, Object a_onObject, long a_fromID, ResultSet a_rs, Connection a_con){
		try{
			long id = a_rs.getLong(i_column);
			if(id > 0){
				id = map(a_con, id);
				
				Object object = a_db.ext().getByID(id);
				if (object != null){
					return object;
				}
				Sql.error("Integrity error. Field:" 
						  + i_field.getName() 
						  + msgId(id)
						  + msgOn(a_onObject)
					);
			}
		}
		catch(Exception e){
			Sql.log("SqlFieldObject.instantiate failed");
		}
		return null;
	}
	
	Object instantiate(ResultSet a_rs){
		return null;
		// ignore
	}
	
	private long map(Connection a_con, long a_fromID){
		if (i_statement == null){
			i_statement = Sql.createStatement(a_con);
		}
		
		if(i_select == null){
			i_select = new SqlSelect();
			i_select.setTable(Sql.MAP);
			i_select.addField(Sql.TO_ID);
		}
		
		i_select.setWhere(Sql.FROM_ID,a_fromID);
		try{
			ResultSet rs = i_statement.executeQuery(i_select.statement());
			if(rs.next()){
				return rs.getLong(1);
			}
		}catch(Exception e){
		}
		Sql.error("Mapping not found in " + Sql.MAP + msgId(a_fromID));
		return a_fromID;
	}
	
	static String msgId(long a_id){
		return " ID:" + new Long(a_id).toString();
	}
	
	static String msgOn(Object a_onObject){
		return " On:" + a_onObject.toString();
		//return " On:" + new Long(a_onObject.getObjectHandle().getInternalID()).toString();
	}
}
