package com.db4o.sql;

import com.db4o.*;
import com.db4o.lib.*;
import java.lang.reflect.*;

class SqlFieldArray extends SqlField
{
	private SqlField i_componentField;
	private SqlTable i_table;
	private String i_tableName;
	private Class i_class;
	
	String fieldCreate(){
		return null;
	}
	
	String fieldCreate(java.sql.Statement a_statement){
		SqlCreateTable create = new SqlCreateTable();
		create.setTable(i_tableName);
		create.addField(i_componentField.getName(), i_componentField.fieldCreate(a_statement));
		create.addField(Sql.ARRAYINDEX, Sql.INTEGER);
		create.addField(Sql.FROM_ID, Sql.INTEGER);
		create.addField(Sql.TO_ID, Sql.INTEGER);
		SqlTable.createTable(a_statement, create);
		return null;
	}
	
	Class getJavaClass(){
		return null;
	}
	
	public String getName(){
		return i_tableName;
	}
	
	Class getWrapperClass(){
		return null;
	}
	
	void insert1(ObjectContainer a_container, Object a_Object, SqlInsert a_insert){
		throw new RuntimeException("insert1 in SqlFieldArray should never be called");
	}
	
	void insert1(ObjectContainer a_container, Object a_onObject, Object a_Object, SqlInsert a_insert, java.sql.Statement a_statement){
		Object l_Object;
		String sqlObjectID = new Long(a_container.ext().getID(a_onObject)).toString();
		int l_length = Array.getLength(a_Object);
		for(int i = 0; i < l_length; i++){
			SqlInsert insert = new SqlInsert();
			insert.setTable(getName());
			insert.addField(Sql.FROM_ID, sqlObjectID);
			insert.addField(Sql.ARRAYINDEX, new Integer(i).toString());
			l_Object = Array.get(a_Object,i);
			if (l_Object != null){
				i_componentField.insert1(a_container, l_Object, insert);
			}
			SqlTable.insert(a_statement, insert);
		}
	}
	
	Object instantiate(ObjectContainer a_db, Object a_onObject, long a_fromID, java.sql.ResultSet a_rs, java.sql.Connection a_con){
		int rightIndex = 0;
		int dbIndex;
		List4 col = new List4();
		SqlSelect select = new SqlSelect();
		select.setTable(getName());
		select.addField(Sql.ARRAYINDEX);
		i_componentField.setColumn(select.addField(i_componentField.getName()));
		select.setWhere(Sql.FROM_ID,a_fromID);
		select.setOrderBy(Sql.ARRAYINDEX);
		try{
			java.sql.Statement statement = Sql.createStatement(a_con);
			java.sql.ResultSet rs = statement.executeQuery(select.statement());
			while ( rs.next()){
				try{
					dbIndex = rs.getInt(1);
					if(dbIndex != rightIndex){
						Sql.error("Array integrity error.");
						sqlErr(rightIndex,a_onObject);
					}
					col.add(i_componentField.instantiate(a_db, a_onObject,a_fromID, rs, a_con));
				}	
				catch(Exception e){
					Sql.error("Error during retrieval of array element.");
					sqlErr(rightIndex,a_onObject);
					Sql.error(e.getMessage());
				}
				rightIndex ++;
			}
		}
		catch(Exception e){
			Sql.error("Failed: " + select.statement());
			Sql.error(e.getMessage());
			return null;
		}
		Object[] objectArray = col.toArray();
		Object castArray;
		castArray = Array.newInstance(i_class, objectArray.length);
		for (int i = 0; i < objectArray.length; i++){
			Array.set(castArray,i,objectArray[i]);
		}
		return castArray;
	}
	
	Object instantiate(java.sql.ResultSet a_rs){
		return null;
		// ignore
	}
	
	boolean onCreate(SqlTable a_table, Class a_class){
		i_class = a_class.getComponentType();
		i_componentField = make(i_class);
		if (i_componentField == null){
			return false;
		}
		i_table = a_table;
		i_tableName = a_table.getName() + "_" + i_name;
		i_componentField.setField(i_field); // so it has the name to be able to use SqlInsert correctly
		return true;
	}

	
	void sqlErr(long a_index, Object a_onObject){
		Sql.error(" Field:" + i_field.getName() + msgIndex(a_index) + SqlFieldObject.msgOn(a_onObject));
	}
	
	static String msgIndex(long a_index){
		return " Index:" + new Long(a_index).toString();
	}
	
	String select(){
		return null;
	}
	
}
