package  com.db4o.sql;

import com.db4o.*;
import com.db4o.ext.*;
import  com.db4o.lib.*;
import  java.sql.*;


/**
 * exports data from db4o to JDBC databases.
 * <br><br>
 * <b>Note:</b> An export run exports all data. A check for duplicates does
 * not take place yet. Be careful to call SqlExport only once.
 */
public class SqlExport {
    private static SqlConfiguration i_config;
    private static ObjectContainer i_db;

    /**
	 * starts SqlExport
     * @param arguments
	 * <br>1.) JDBC driver<br>
	 * 2.) JDBC connection String to destination<br>
	 * 3.) db4o datafile used as source
	 * 4.) optional user for the JDBC connection
	 * 5.) optional password for the JDBC connection
	 *
     */
    public static void main (String[] args) {
        try {
            i_config = new SqlConfiguration(args, false);
            try {
                Timer.start("SqlExport completed");
                Connection con = Sql.connect(i_config);
                if (con != null) {
                    i_db = Db4o.openFile(i_config.getDbFile());
					StoredClass[] intClasses = i_db.ext().storedClasses();
					String[] classes = new String[intClasses.length];
					for(int i=0; i < intClasses.length; i++){
						classes[i] = intClasses[i].getName();
					}
                    createTables(con, classes);
                    insert(i_db, con, classes);
                    i_db.close();
                    Timer.stop("SqlExport completed");
                }
            } catch (Exception e) {
                Sql.exception("SQLExport raises Exception:");
                Sql.exception(e.getMessage());
            }
        } catch (Exception e) {}
    }

    /**
     * @param a_con
     * @param a_classes
     * @exception SQLException
     */
    static void createTables (Connection a_con, String[] a_classes) throws SQLException {
        Statement statement = Sql.createStatement(a_con);
        Sql.createMap(statement);
        for (int i = 0; i < a_classes.length; i++) {
            SqlTable table = SqlTable.analyze(a_classes[i], true);
            table.createTable(statement,true);
            a_con.commit();
        }
    }

    /**
     * @param a_con
     * @param a_classes
     */
    static void insert (ObjectContainer a_container, Connection a_con, String[] a_classes) {
        Statement statement = Sql.createStatement(a_con);
        SqlTable table;
        Object obj = null;
		ObjectSet os;
        for (int i = 0; i < a_classes.length; i++) {
            try {
                obj = Class.forName(a_classes[i]).newInstance();
                table = SqlTable.analyze(a_classes[i], true);
                Sql.log("Inserting into table:" + table.getName());
                os = i_db.get(obj);
                while (os.hasNext()) {
                    table.insert(a_container, os.next(), statement);
                }
                a_con.commit();
            } catch (Exception e) {}
        }
    }
}



