package com.db4o.samples.update;

import com.db4o.*;

/**
 * All the following samples in this folder demonstrate
 * methods to alternate the behaviour of db4o by changing
 * configuration settings.
 */
public class U03_Global_Update_Depth extends U02_Update_Every_Object_Explicly {
	public static void main(String[] args) {
		Db4o.configure().messageLevel(-1);

		// This setting will force db4o to update all objects to the deepest
		// level possible. It will take all the troubles away from your code
		// but it will be comparatively slow, since all object attributes will
		// be written back to disk upon every call to ObjectContainer#set()

		Db4o.configure().updateDepth(2);

		new U03_Global_Update_Depth().run();

	}

	public void run() {

		createDB();

		// although we only update the root object, notice the 
		// modified "1002" value
		updateRootOnly();

		logLists();

	}

}
