package com.db4o.samples.update;

import com.db4o.*;

public class U02_Update_Every_Object_Explicly extends U01_New_Always_Cascades {
	public static void main(String[] args) {
		Db4o.configure().messageLevel(-1);
		
		new U02_Update_Every_Object_Explicly().update();
	}

	public void update() {
		createDB();
		updateRootOnly();
		logLists(); // no change is visible
		updateChangedObject();
		logLists();
	}

	public void updateRootOnly() {
		System.out.println("UPDATE root");
		ObjectContainer con = Db4o.openFile(filename);
		ObjectSet set = con.get(new ListSample(1));
		while (set.hasNext()) {
			ListSample root = (ListSample) set.next();
			root.next.intField = root.next.intField + 1000;

			// The following statement will only update "root".
			// By default "root.next" will NOT be updated.

			con.set(root);

		}
		con.close();
	}

	public void updateChangedObject() {
		System.out.println("UPDATE root.next");
		ObjectContainer con = Db4o.openFile(filename);
		ObjectSet set = con.get(new ListSample(1));
		while (set.hasNext()) {
			ListSample root = (ListSample) set.next();
			root.next.intField = root.next.intField + 1000;

			// Here we update the changed object explicitely
			con.set(root.next);

		}
		con.close();
	}
}
