package com.db4o.samples.update;

import com.db4o.*;

public class U01_New_Always_Cascades {
	public static final String filename = "update.yap";
	// Attention!!  This file is deleted on running this class.

	public static void main(String[] args) {
		Db4o.configure().messageLevel(-1);
		
		// create the root of a list with 5 elements
		// store it and log all the created list objects
		U01_New_Always_Cascades main = new U01_New_Always_Cascades();
		main.createDB();
		main.logLists();
	}

	public ListSample createList() {
		return new ListSample().createList(5);
	}

	public void createDB() {
		new java.io.File(filename).delete();
		ObjectContainer con = Db4o.openFile(filename);

		// Only one call to #set is necessary to add new objects.
		// All reachable objects will be traversed and stored also.
		con.set(createList());

		con.close();
	}

	public void logLists() {
		ObjectContainer con = Db4o.openFile(filename);
		ObjectSet set = con.get(new ListSample(1));
		while (set.hasNext()) {
			ListSample list = (ListSample) set.next();
			con.activate(list, Integer.MAX_VALUE);
			com.db4o.tools.Logger.log(con, list);
		}
		con.close();
	}
}
