package com.db4o.samples.translators;

import com.db4o.ObjectContainer;
import com.db4o.config.*;
import java.io.*;

/**
 * translator for classes that implement the Serializable interface.
 * The use of this translator is not recommended since:<br>
 * - refactoring serialized classes is difficult<br>
 * - members can not be queried for individually<br>
 * - a lot of overhead is stored<br>
 * - the mechanism is comparatively slower<br>
 * Instead it is recommended to write specific translators for every single class
 * to store member objects individually.<br>
 * The Serializable translator is provided to allow implementing solutions very
 * quickly where the above points are of no concern.
 */
public class TSerializable implements ObjectConstructor
{
	public Object onStore(ObjectContainer con, Object object){
		try{
			ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
			new ObjectOutputStream(byteStream).writeObject(object);
			return byteStream.toByteArray();
		}catch (Exception e){}
		return null;
	}

	public void onActivate(ObjectContainer con, Object object, Object members){
		// do nothing
	}

	public Object onInstantiate(ObjectContainer container, Object storedObject){
		try{
		    Object in = new ObjectInputStream(
			  new ByteArrayInputStream((byte[])storedObject)).readObject();
			return in;
		}catch(Exception e){}
		return null;
	}

	public Class storedClass(){
		return byte[].class;
	}
}
