package com.db4o.samples.translators;

import com.db4o.ObjectContainer;
import com.db4o.config.*;
import java.util.*;

public class TMap implements ObjectTranslator
{
	public Object onStore(ObjectContainer con, Object object){
		Map map = (Map)object;
		com.db4o.config.Entry[] entries = new com.db4o.config.Entry[map.size()];
		Iterator it = map.keySet().iterator();
		int i = 0;
		while(it.hasNext()){
			entries[i] = new com.db4o.config.Entry();
			entries[i].key = it.next();
			entries[i].value = map.get(entries[i].key);
			i++;
		}
		return entries;
	}

	public void onActivate(ObjectContainer con, Object object, Object members){
		Map map = (Map)object;
		map.clear();
		if(members != null){
			com.db4o.config.Entry[] entries = (com.db4o.config.Entry[]) members;
			for(int i = 0; i < entries.length; i++){
				if(entries[i].key != null && entries[i].value != null){
					map.put(entries[i].key,entries[i].value);
				}
			}
		}
	}

	public Class storedClass(){
		return com.db4o.config.Entry[].class;
	}
}
