package com.db4o.samples.translators;

import com.db4o.ObjectContainer;
import com.db4o.config.*;
import java.util.*;

public class THashtable implements ObjectTranslator
{
	public Class forClass(){
		return java.util.Hashtable.class;
	}

	public Object onStore(ObjectContainer con, Object object){
		Hashtable ht = (Hashtable)object;
		com.db4o.config.Entry[] entries = new com.db4o.config.Entry[ht.size()];
		Enumeration enum = ht.keys();
		int i = 0;
		while(enum.hasMoreElements()){
			entries[i] = new com.db4o.config.Entry();
			entries[i].key = enum.nextElement();
			entries[i].value = ht.get(entries[i].key);
			i++;
		}
		return entries;
	}

	public void onActivate(ObjectContainer con, Object object, Object members){
		Hashtable ht = (Hashtable)object;
		ht.clear();
		if(members != null){
			com.db4o.config.Entry[] entries = (com.db4o.config.Entry[]) members;
			for(int i = 0; i < entries.length; i++){
				if(entries[i].key != null && entries[i].value != null){
					ht.put(entries[i].key,entries[i].value);
				}
			}
		}
	}

	public Class storedClass(){
		return com.db4o.config.Entry[].class;
	}
}
