package com.db4o.samples.translators;

import com.db4o.*;
import com.db4o.config.*;

class Default
{
	/**
	 * The following code lists all translators db4o internally uses to store
	 * some of the JDK classes. You do not need to call this method and this method
	 * is never called by db4o. It only is a duplicate of the internally used code
	 * to serve as a documentation for you to understand the mechanism.
	 *
	 * You may consider to change internal translators for performance reasons.
	 * Please be aware that changing translators in a production environment
	 * may easily lead to corrupted data. Test this feature with non-production
	 * data <b>only</b>.
	 *
	 * The preconfigured updateDepth() for the JDK2 Collection classes might be
	 * worthwhile experimenting for performance reasons.
	 */
	void defaultConfiguration() {
		Configuration config = Db4o.configure();
		boolean isJDK1 = false;
		try {
			Class.forName("java.util.AbstractCollection");
		} catch (Throwable t) {
			isJDK1 = true;
		}
		translateCollection(config, "java.util.Hashtable", "THashtable", true);
		translate(config, "java.lang.Class", "TClass");
		if (isJDK1) {
			translateCollection(config, "java.util.Vector", "TVector", false);
		} else {
			try {
				translateCollection(config, "java.util.AbstractCollection", "TCollection", false);
				translate(config, "java.util.AbstractList", "TNull");
				translate(config, "java.util.AbstractSequentialList", "TNull");
				translate(config, "java.util.LinkedList", "TNull");
				translate(config, "java.util.ArrayList", "TNull");
				translate(config, "java.util.Vector", "TNull");
				translate(config, "java.util.Stack", "TNull");
				translate(config, "java.util.AbstractSet", "TNull");
				translate(config, "java.util.HashSet", "TNull");
				translate(config, "java.util.TreeSet", "TTreeSet");
				translateCollection(config, "java.util.AbstractMap", "TMap", true);
				translate(config, "java.util.HashMap", "TNull");
				translate(config, "java.util.TreeMap", "TTreeMap");
				translate(config, "java.util.WeakHashMap", "TNull");

			} catch (Exception e) {
			}
		}
	}

	private static final void translate(Configuration config, String from, String to) {
		translate(config, config.objectClass(from), to);
	}

	private static final void translateCollection(
		Configuration config,
		String from,
		String to,
		boolean cascadeOnDelete) {
		ObjectClass oc = config.objectClass(from);
		oc.updateDepth(3);
		if(cascadeOnDelete){
			oc.cascadeOnDelete(true);
		}
		translate(config, oc, to);
	}

	private static final void translate(Configuration config, ObjectClass oc, String to) {
		String translator = "com.db4o.config." + to;
		try {
			oc.translate(
				(ObjectTranslator) Class.forName(translator).newInstance());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static final boolean methodIsAvailable(
		String className,
		String methodName,
		Class[] params) {
		try {
			Class clazz = Class.forName(className);
			if (clazz.getMethod(methodName, params) != null) {
				return true;
			}
		} catch (Error e) {
		} catch (Throwable t) {
		}
		return false;
	}
	
}
