/*
 * (c) Copyright 2002 http://www.db4o.com
 * All Rights Reserved.
 */
package com.db4o.samples.reflect;

import com.db4o.reflect.*;

/**
 * root of the reflection API.
 * <br><br>Install with <code>Db4o.configure().reflectWith(IReflect reflector)</code>.
 * <br><br>see TestReflect.java for further documentation.
 */
public class CReflect implements IReflect{
	
	private final IArray array;
	
	public CReflect(){
		array = new CArray();
	}
	
	public IArray array(){
		return array;
	}
	
	public boolean constructorCallsSupported(){
		return true;
	}
	
	public IClass forName(String className) throws ClassNotFoundException{
		return new CClass(Class.forName(className));
	}
	
	public boolean methodCallsSupported(){
		return true;
	}
}
