/*
 * (c) Copyright 2002 http://www.db4o.com
 * All Rights Reserved.
 */
package com.db4o.samples.reflect;

import java.lang.reflect.*;

import com.db4o.reflect.*;

/**
 * representation of java.lang.reflect.Method
 * <br><br>see TestReflect.java for further documentation.
 */
public class CMethod implements IMethod{
	
	private final Method method;
	
	public CMethod(Method method){
		this.method = method;
	}
	
	public Object invoke(Object onObject, Object[] parameters){
		try {
			return method.invoke(onObject, parameters);
		} catch (IllegalAccessException e) {
			return null;
		} catch (InvocationTargetException e) {
			return null;
		}
	}
}
