/*
 * (c) Copyright 2002 http://www.db4o.com
 * All Rights Reserved.
 */
package com.db4o.samples.reflect;

import java.lang.reflect.*;

import com.db4o.reflect.*;

/**
 * representation of java.lang.reflect.Field
 * <br><br>see TestReflect.java for further documentation.
 */
public class CField implements IField{
	
	private final Field field;
	
	public CField(Field field){
		this.field = field;
	}
	
	public String getName(){
		return field.getName();
	}
	
	public Class getType(){
		return field.getType();
	}
	
	public boolean isPublic(){
		return Modifier.isPublic(field.getModifiers());
	}
	
	public boolean isStatic(){
		return Modifier.isStatic(field.getModifiers());
	}
	
	public boolean isTransient(){
		return Modifier.isTransient(field.getModifiers());
	}
	
	public void setAccessible(){
		// implemented within the db4o engine, depending upon the Platform
		// Platform.setAccessible(field);
	}
	
	public Object get(Object onObject){
		try {
			return field.get(onObject);
		} catch (IllegalAccessException e) {
			return null;
		}
	}
	
	public void set(Object onObject, Object attribute){
		try {
			field.set(onObject, attribute);
		} catch (IllegalAccessException e) {
		}
	}
}
