/*
 * (c) Copyright 2002 http://www.db4o.com
 * All Rights Reserved.
 */
package com.db4o.samples.reflect;

import java.lang.reflect.*;

import com.db4o.reflect.*;

/**
 * representation of java.lang.reflect.Constructor
 * <br><br>see TestReflect.java for further documentation.
 */
public class CConstructor implements IConstructor{
	
	private final Constructor constructor;
	
	public CConstructor(Constructor constructor){
		this.constructor = constructor;
	}
	
	public Class[] getParameterTypes(){
		return constructor.getParameterTypes();
	}
	
	public void setAccessible(){
		// implemented within the db4o engine, depending upon the Platform
		// Platform.setAccessible(constructor);
	}
	
	public Object newInstance(Object[] parameters){
		try {
			return constructor.newInstance(parameters);
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		} catch (InvocationTargetException e) {
		}
		return null;
	}
}
