/*
 * (c) Copyright 2002 http://www.db4o.com
 * All Rights Reserved.
 */
package com.db4o.samples.reflect;

import java.lang.reflect.*;

import com.db4o.reflect.*;

/**
 * representation of java.lang.Class
 * <br><br>see TestReflect.java for further documentation.
 */
public class CClass implements IClass{
	
	private final Class clazz;
	
	public CClass(Class clazz){
		this.clazz = clazz;
	}
	
	public IConstructor[] getDeclaredConstructors(){
		Constructor[] constructors = clazz.getDeclaredConstructors();
		IConstructor[] reflectors = new IConstructor[constructors.length];
		for (int i = 0; i < constructors.length; i++) {
			reflectors[i] = new CConstructor(constructors[i]);
		}
		return reflectors;
	}
	
	public IField getDeclaredField(String name){
		try {
			return new CField(clazz.getDeclaredField(name));
		} catch (NoSuchFieldException e) {
			return null;
		}
	}
	
	public IField[] getDeclaredFields(){
		Field[] fields = clazz.getDeclaredFields();
		IField[] reflectors = new IField[fields.length];
		for (int i = 0; i < reflectors.length; i++) {
			reflectors[i] = new CField(fields[i]);
		}
		return reflectors;
	}
	
	public IMethod getMethod(String methodName, Class[] paramClasses){
		try {
			return new CMethod(clazz.getMethod(methodName, paramClasses));
		} catch (NoSuchMethodException e) {
			return null;
		}
	}
	
	public boolean isAbstract(){
		return Modifier.isAbstract(clazz.getModifiers());
	}
	
	public boolean isInterface(){
		return clazz.isInterface();
	}
	
	public Object newInstance(){
		try {
			return clazz.newInstance();
		} catch (InstantiationException e) {
			return null;
		} catch (IllegalAccessException e) {
			return null;
		}
	}
}
