package com.db4o.samples.messaging;

import com.db4o.*;
import com.db4o.messaging.*;
import com.db4o.samples.clientserver.*;

/**
 * the simplest possible messaging example 
 */
public class MSG01_Hello implements MessageRecipient, ServerConfiguration {

	public static void main(String[] args) throws Exception {

		// open server and client
		ObjectServer objectServer = Db4o.openServer("msg01.yap", 4490);
		objectServer.grantAccess("db4o", "db4o");
		ObjectContainer clientObjectContainer = Db4o.openClient("localhost", 4490, "db4o", "db4o");

		// a new MSG01_Hello object is registered as a MessageRecipient
		// This will direct all messages sent to this server to the
		// processMessage method of this instance.
		objectServer.ext().configure().setMessageRecipient(new MSG01_Hello());

		// get the MessageSender object for the client
		MessageSender messageSender = clientObjectContainer.ext().configure().getMessageSender();

		
		// send some messages
		// these need to be first class objects (no primitives, or string)
		messageSender.send(new MyMessageClass());
		messageSender.send(new MSG01_Hello());
		

		// close client and server
		clientObjectContainer.close();
		objectServer.close();
	}

	/**
	 * this is the callback method called from the server upon Messages 
	 */
	public void processMessage(ObjectContainer con, Object message) {
		System.out.println("\nMSG01_Hello processMessage. Message arrived:");
		System.out.println(message + "\n");
	}
	
	public static class MyMessageClass{
		
	}
}
