package com.db4o.samples.constructors;

import java.io.*;

import com.db4o.*;


/**
 * The samples in this folder try to demonstrate possible side-effects,
 * if no empty zero-parameter constructor is supplied.
 * 
 * db4o behaves as follows:
 * - Upon storing an instance of an object of a class for the first time,
 * db4o attempts to find a usable constructor for this class.
 * - Ideally a public default zero-parameter constructor is used.
 * - If a default constructor is not present, db4o will iterate through all
 * other constructors and try to create a test-object. 
 * - The first constructor that can successfully be used, will be used 
 * throughout the entire db4o session.
 * - If db4o is not successful at creating an instance of the class, db4o will
 * not store objects of this class.
 * - db4o can be configured to throw Exceptions in this last case, to help
 * detect problems.
 */
public class ConstructorExamples {
	
	private static final String FILE = "Constructors.yap";
	
	public static void store(Object obj){
		try{
			// Deleting the database file, so we have no side effects from
			// other objects.
			new File(FILE).delete();
			Db4o.configure().messageLevel(4);
			ObjectContainer con = Db4o.openFile(FILE);
			con.set(obj);
			con.close();
			
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	
	public static void retrieve(Object obj){
		ObjectContainer con = Db4o.openFile(FILE);
		ObjectSet set = con.get(obj);
		// The stars make this line very visible in the log.
		System.out.println("****************** NUMBER OF STORED OBJECTS: *** " + set.size() + " ***  ******************");
		while(set.hasNext()){
			set.next();
		}
		con.close();
	}
	
	
}
