package com.db4o.samples.constructors;

import com.db4o.*;

/**
 * This example documents that db4o will iterate through all the present constructors
 * and use the first one that is successful at creating an instance of the class.
 * 
 * Note that all sorts of side-effects may be accidentally triggered.
 * 
 * This is why a public default constructor is recommended, but not necessary.
 * 
 * The side-effects will only occur once, when db4o searches for the constructor.
 * Once the engine is up, it will continue to use the one constructor that was
 * successful, without further tests.
 */
public class Con05RandomUseOfSuccessFullConstructor {
	
	public static void main(String[] args) {
		Db4o.configure().messageLevel(-1);
		
		Con05RandomUseOfSuccessFullConstructorClass c05 = new Con05RandomUseOfSuccessFullConstructorClass("test");
		ConstructorExamples.store(c05);
		ConstructorExamples.retrieve(c05);
	}
}
