package com.db4o.samples.constructors;

import com.db4o.*;


/**
 * This example documents a configuration setting that may be helpful to find
 * classes that can not be stored.
 */
public class Con04ExceptionsOnNotStorable {
	
	public static void main(String[] args) {
		Db4o.configure().messageLevel(-1);
		
		Con04ExceptionsOnNotStorableClass c04 = new Con04ExceptionsOnNotStorableClass("test");
		
		// this method call will tell db4o to throw Exceptions, if a certain
		// class can not be stored. The stacktrace will help you find the
		// class name.
		Db4o.configure().exceptionsOnNotStorable(true);
		
		
		try{
			ConstructorExamples.store(c04);
			ConstructorExamples.retrieve(c04);
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}
