package com.db4o.samples.clientserver;

import com.db4o.*;
import com.db4o.tools.*;

/**
 * the simplest possible client/server example   
 */
public class CS01_Hello {
	
	public static void main(String[] args) throws Exception{
		
		// open the server on file "cs01.yap" and port 4489
		ObjectServer objectServer = Db4o.openServer("cs01.yap",4489);
		
		// grant access to the user "db4o" with password "db4o"
		objectServer.grantAccess("db4o", "db4o");
		
		// connect to the local server with user "db4o" and password "db4o"
		ObjectContainer objectContainer = Db4o.openClient("localhost", 4489, "db4o", "db4o");
		
		// a client ObjectContainer works the same as a normal one
		objectContainer.set(new CS01_Hello());
		System.out.println("\n\n*>> Logging content of cs01.yap");
		ObjectSet objectSet = objectContainer.get(null);
		while(objectSet.hasNext()){
			Logger.log(objectContainer, objectSet.next());
		}
		System.out.println("*<<\n\n");
		
		// close the client first
		objectContainer.close();
		
		// close the server
		objectServer.close();
	}
	
}
