package com.db4o.samples.callbacks;

import com.db4o.*;

public class ListOnDelete extends ListOnNew
{
	public ListOnDelete(){
	}
	
	public ListOnDelete(int value){
		super(value);
	}
	
	/**
	 * we use the delete callback method to cascade delete 
	 * to every second element in the list
	 */
	public void objectOnDelete(ObjectContainer con){
		ListOnDelete cascadeTo = (ListOnDelete)this.next;
		if(cascadeTo != null){
			con.activate(cascadeTo, 2); // make sure cascadeTo and its member is activated
			con.delete(cascadeTo.next);
		}
	}
	
}
