package com.db4o.samples.callbacks;

import com.db4o.*;

public class C04_CascadeOnDelete extends C01_CascadeOnNew
{
	public static void main(String[] args){

		Db4o.configure().messageLevel(-1);
		
		// Create a ListOnUpdate list and log all elements
		C04_CascadeOnDelete main = new C04_CascadeOnDelete();
		main.set(new ListOnDelete(10));
		
		// cascade deletes 
		main.delete();
		
		// log all lists again
		main.logLists();
	}
	
	public void delete(){
		
		ObjectContainer con = Db4o.openFile(FILE);
		
		// get the root
		ListOnDelete list = (ListOnDelete) con.get(new ListOnDelete(1)).next();
		
		// delete it
		// see ListOnDelete#objectOnDelete to understand how the delete
		// is cascaded to every second List element in the list
		con.delete(list);
		
		con.close();
		
		System.out.println("AFTER DELETE:");
	}
}

