package com.db4o.samples.callbacks;

import com.db4o.*;

public class C03_CascadeOnUpdate extends C01_CascadeOnNew
{
	public static void main(String[] args){
		
		Db4o.configure().messageLevel(-1);
		
		// Create a ListOnUpdate list and log all elements
		C03_CascadeOnUpdate main = new C03_CascadeOnUpdate();
		main.set(new ListOnUpdate(5));
		
		// cascade updates 
		main.update();
		
		// log all lists again
		main.logLists();
	}
	
	public void update(){
		ObjectContainer con = Db4o.openFile(FILE);
		
		// get the root
		ListOnUpdate list = (ListOnUpdate) con.get(new ListOnUpdate(1)).next();
		
		// create a difference of 20 between intField and objectfield.
		list.objectField = new Integer(list.intField + 20);

		// see ListOnUpdate#objectOnUpdate to understand
		// how the above update is cascaded to all members
		con.set(list);
		
		con.close();
		
		System.out.println("AFTER UPDATE:");
	}
	
	
}

