package com.db4o.samples.callbacks;

import com.db4o.*;
import com.db4o.samples.*;

public class C02_CascadeOnActivate extends C01_CascadeOnNew
{
	public static void main(String[] args){
		
		Db4o.configure().messageLevel(-1);
		
		// Create a list of 5 ListOnActivate objects.
		new C02_CascadeOnActivate().set(new ListOnActivate(5));
		
	}
	
	
	public void logLists(){
		// logLists is overridden to demonstrate cascaded activation
		
		// Depth 1 automatic activation
		Db4o.configure().activationDepth(1);
		
		ObjectContainer con = Db4o.openFile(FILE);
		
		// retrieve the root only
		ObjectSet set = con.get(new ListOnActivate(1));
		if (set.hasNext()){
			
			// activate the root to level 1
			ListSample list = (ListSample)set.next();
			
			// See the code in ListOnActivate#objectOnActivate 
			// to understand how activation is cascaded to members
			// and where the output to System.out comes from. 
			
		}
		con.close();
	}
}

